#ifndef _PLATFORM_TYPES_H
#define _PLATFORM_TYPES_H
/******************************************************************************
*                             EddeFlex All rights reserved
*******************************************************************************
*                    File: Platform_Types.h
*             Description: header file
*      Platform Dependent: no
*                   Notes:
******************************************************************************/

#define FALSE    0x00U
#define TRUE     0x01U

#define CPU_TYPE_8         8U
#define CPU_TYPE_16        16U
#define CPU_TYPE_32        32U

#define MSB_FIRST          0U
#define LSB_FIRST          1U
#define HIGH_BYTE_FIRST    0U
#define LOW_BYTE_FIRST     1U

#define CPU_TYPE           CPU_TYPE_32
#define CPU_BIT_ORDER      LSB_FIRST
#define CPU_BYTE_ORDER     HIGH_BYTE_FIRST

typedef unsigned char           boolean;
typedef signed char             sint8;          /*        -128 .. +127            */
typedef unsigned char           uint8;          /*           0 .. 255             */
typedef signed short            sint16;         /*      -32768 .. +32767          */
typedef unsigned short          uint16;         /*           0 .. 65535           */
typedef signed int              sint32;         /* -2147483648 .. +2147483647     */
typedef unsigned int            uint32;         /*           0 .. 4294967295      */
typedef long long               sint64;
typedef unsigned long long      uint64;

typedef float                   float32;
typedef double                  float64;

/******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _PLATFORM_TYPES_H */
