#ifndef _STD_TYPES_H
#define _STD_TYPES_H
/******************************************************************************
*                             EddeFlex All rights reserved
*******************************************************************************
*                    File: Std_Types.h
*             Description: header file
*      Platform Dependent: no
*                   Notes:
******************************************************************************/

#include "Platform_Types.h"

#define E_OK        0x00U
#define E_NOT_OK    0x01U

#define STD_HIGH    0x01U /* Physical state 5V or 3.3V */
#define STD_LOW     0x00U /* Physical state 0V */

#define STD_ACTIVE  0x01u /* Logical state active */
#define STD_IDLE    0x00u /* Logical state idle */

typedef uint8 Std_ReturnType;

typedef struct
{
    uint16 vendorID;
    uint16 moduleID;
    uint8  sw_major_version;
    uint8  sw_minor_version;
    uint8  sw_patch_version;
}Std_VersionInfoType;


/******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _STD_TYPES_H */
