#ifndef _EDDEOS_H_
#define _EDDEOS_H_
/******************************************************************************
*                             EddeFlex All rights reserved
*******************************************************************************
*                    File: EddeOS.h
*             Description: OS header
*      Platform Dependent: no
*                   Notes:
******************************************************************************/


/******************************************************************************
*                              MACROS section
******************************************************************************/
#define ISR(ISR_Name)    void ISR_Name (void)

#define TASK(TASK_Name)  void TASK_Name (void)

#define DeclareTask(TaskPtr,TaskSts)    {TaskPtr,TaskSts}

#define DeclareAlarm(increment,cycle,TaskID)    {increment,cycle,TaskID}


/******************************************************************************
*                              OS Global datatypes section
******************************************************************************/
typedef enum
{
	E_OS_OK       = 0,
	E_OS_ACCESS   = 1,
	E_OS_CALLEVEL = 2,
	E_OS_ID       = 3,
	E_OS_LIMIT    = 4,
	E_OS_NOFUNC   = 5,
	E_OS_RESOURCE = 6,
	E_OS_STATE    = 7,
	E_OS_VALUE    = 8
}StatusType;

typedef enum
{

   OS_NORMAL_MODE,
   OS_SHUTDOWN_MODE

}AppModeType;



/******************************************************************************
*                              OS execution prototypes section
******************************************************************************/
extern void EddeOS_Init (void);
extern void EddeOS_StartOS ( AppModeType Mode);
extern void EddeOS_ShutdownOS ( StatusType Error);


/******************************************************************************
*                              OS Task management datatypes section
******************************************************************************/
typedef uint8     TaskType;

typedef TaskType* TaskRefType;

typedef enum
{
	TASK_RUNNING,
	TASK_WAITING,
	TASK_READY,
	TASK_SUSPENDED,
	TASK_INVALID_TASK
}TaskStateType;

typedef TaskStateType* TaskStateRefType;

typedef struct 
{
   void (*TaskPtr)(void);
   TaskStateType Task_State;
}TaskObject;


/******************************************************************************
*                              OS Task management prototypes section
******************************************************************************/
extern StatusType ActivateTask ( TaskType Task_ID );
extern StatusType TerminateTask ( void );
extern StatusType Schedule ( void );
extern StatusType GetTaskID ( TaskRefType Task_ID );
extern StatusType GetTaskState ( TaskType Task_ID,TaskStateRefType State );


/******************************************************************************
*                              OS Alarms datatypes section
******************************************************************************/
typedef uint16 TickType;

typedef TickType* TickRefType;

typedef uint16 AlarmType;

typedef struct 
{
	TickType increment;
	TickType cycle;
	TaskType TaskID;
}AlarmObject;

typedef struct
{
   TickType maxallowedvalue;
   TickType ticksperbase;
   TickType mincycle;
} AlarmBaseType;


/******************************************************************************
*                              OS Alarms prototypes section
******************************************************************************/
extern StatusType SetRelAlarm ( AlarmType Alarm_ID,TickType Increment,TickType Cycle);
extern StatusType SetAbsAlarm( AlarmType Alarm_ID, TickType Start, TickType Cycle );
extern StatusType GetAlarm ( AlarmType Alarm_ID,TickRefType Tick);
extern StatusType CancelAlarm ( AlarmType Alarm_ID);
extern void OS_Timer_Interrupts(void);


/******************************************************************************
*                              Events datatypes section
******************************************************************************/


/******************************************************************************
*                              Events prototypes section
******************************************************************************/
extern StatusType SetEvent ( TaskType TaskID );
extern StatusType ClearEvent ( TaskType TaskID );
extern StatusType TerminateEvent ( void );

/******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _EDDEOS_H_ */

