/******************************************************************************
*                             EddeFlex All rights reserved
*******************************************************************************
*                    File: EddeOS_App.c
*             Description: OS
*      Platform Dependent: no
*                   Notes:
******************************************************************************/


/******************************************************************************
*                              include section
******************************************************************************/
#include "Std_Types.h"
#include "rom.h"
#include "hw_memmap.h"
#include "EddeOS.h"
#include "EddeOS_App.h"
#include "GPIO.h"
#include "CAN.h"
#include "MCP2515.h"


/******************************************************************************
*                                MACROS
******************************************************************************/
#define TXCAN_Msg_ID           0xA0
#define TXCAN_Msg_Len          6
#define TXCAN_Msg_Obj          1
#define TXCAN_Msg1_ID          0xC0
#define TXCAN_Msg1_Len         8
#define RXCAN_Msg_Obj          3
#define CAN_Msg_ID_Filter      0
#define RXCAN_Msg_Obj_3_INT    0b100
#define CAN0_ID                0
#define CAN1_ID                1
#define MCP2515_CS12           GPIO_PIN_3

/******************************************************************************
*                              shared variables section
******************************************************************************/
uint8 TXCAN_Msg_Data[6] = {'N','a','t','i','v','e'};
uint8 TXCAN_Msg1_Data[8] = {'E','x','t','e','r','n','a','l'};
uint8 RXCAN_Msg_Data[8];
strCANMsgObject TXCAN_Msg =
{
    TXCAN_Msg_ID,
    CAN_Msg_ID_Filter,
    MSG_OBJ_NO_FLAGS,
    TXCAN_Msg_Len,
    TXCAN_Msg_Data
};

strCANMsgObject TXCAN_Msg1 =
{
    TXCAN_Msg1_ID,
    CAN_Msg_ID_Filter,
    MSG_OBJ_NO_FLAGS,
    TXCAN_Msg1_Len,
    TXCAN_Msg1_Data
};

strCANMsgObject RXCAN_Msg = {0,CAN_Msg_ID_Filter,MSG_OBJ_RX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER,0,RXCAN_Msg_Data};


/******************************************************************************
*                              Functions prototypes
******************************************************************************/
extern void UART0_Write_CAN_Msg(const uint8 u8CANCntID,uint32 u32MsgID, uint8* u8MsgData, uint8 u8MsgLen);


/******************************************************************************
*                              Tasks declaration
******************************************************************************/
TaskObject Tasks[MAX_NUM_OF_TASKS] =
{
    DeclareTask(&TASK_100ms,TASK_SUSPENDED),
    DeclareTask(&TASK_1000ms,TASK_SUSPENDED)
};


/******************************************************************************
*                              Alarms declaration
******************************************************************************/
AlarmObject Alarms[MAX_NUM_OF_ALARMS] =
{
    DeclareAlarm(100U,100U,Task_100ms_ID),
    DeclareAlarm(1000U,1000U,Task_1000ms_ID)
};


/******************************************************************************
*                              Tasks body
******************************************************************************/

/******************************************************************************
*       Function name: TASK_100ms
*         Description: -
*     Parameters (IN): -
*    Parameters (OUT): -
* Parameters (IN/OUT): -
*        Return value: -
*    Global variables: -
*             Remarks: <any other details including if this function disables interrupt>
******************************************************************************/
TASK(TASK_100ms)
{
    uint32 u32CANStatus;

    u32CANStatus = ROM_CANStatusGet(CAN0_BASE,CAN_STS_NEWDAT);
    if(RXCAN_Msg_Obj_3_INT == u32CANStatus)
    {
        ROM_CANMessageGet(CAN0_BASE,RXCAN_Msg_Obj,&RXCAN_Msg,0);
        UART0_Write_CAN_Msg(CAN0_ID, RXCAN_Msg.ui32MsgID,RXCAN_Msg.pui8MsgData,RXCAN_Msg.ui32MsgLen);

    }

    u32CANStatus = MCP2515_CANStatusGet(MCP2515_CS12);
    if(MCP2515_Stat_RX0Buff == (u32CANStatus & MCP2515_Stat_RX0Buff))
    {
        MCP2515_CANIntClear(MCP2515_CS12, MCP2515_Int_RX0Buff);
        MCP2515_CANMessageGet(MCP2515_CS12, MCP2515_RX0_ID, &RXCAN_Msg);
        UART0_Write_CAN_Msg(CAN1_ID, RXCAN_Msg.ui32MsgID,RXCAN_Msg.pui8MsgData,RXCAN_Msg.ui32MsgLen);
    }

    TerminateTask();
}


/******************************************************************************
*       Function name: TASK_1000ms
*         Description: -
*     Parameters (IN): -
*    Parameters (OUT): -
* Parameters (IN/OUT): -
*        Return value: -
*    Global variables: -
*             Remarks: <any other details including if this function disables interrupt>
******************************************************************************/
TASK(TASK_1000ms)
{
    ROM_CANMessageSet(CAN0_BASE,TXCAN_Msg_Obj,&TXCAN_Msg,MSG_OBJ_TYPE_TX);
    MCP2515_CANMessageSet(MCP2515_CS12, MCP2515_TX0_ID, &TXCAN_Msg1);
    TerminateTask();
}

/******************************************************************************
*                              End of file
******************************************************************************/
