#ifndef _ADC_H_
#define _ADC_H_
/******************************************************************************
*                 Texas Instruments Incorporated. All rights reserved
*******************************************************************************
*                    File: ADC.h
*             Description: ADC Driver
*      Platform Dependent: no
*                   Notes:
******************************************************************************/


/******************************************************************************
*
* Values that can be passed to ADCSequenceConfigure as the ui32Trigger
* parameter.
*
******************************************************************************/
#define ADC_TRIGGER_PROCESSOR   0x00000000  /* Processor event           */
#define ADC_TRIGGER_COMP0       0x00000001  /* Analog comparator 0 event */
#define ADC_TRIGGER_COMP1       0x00000002  /* Analog comparator 1 event */
#define ADC_TRIGGER_COMP2       0x00000003  /* Analog comparator 2 event */
#define ADC_TRIGGER_EXTERNAL    0x00000004  /* External event            */
#define ADC_TRIGGER_TIMER       0x00000005  /* Timer event               */
#define ADC_TRIGGER_PWM0        0x00000006  /* PWM0 event                */
#define ADC_TRIGGER_PWM1        0x00000007  /* PWM1 event                */
#define ADC_TRIGGER_PWM2        0x00000008  /* PWM2 event                */
#define ADC_TRIGGER_PWM3        0x00000009  /* PWM3 event                */
#define ADC_TRIGGER_NEVER       0x0000000E  /* Never Trigger             */
#define ADC_TRIGGER_ALWAYS      0x0000000F  /* Always event              */
#define ADC_TRIGGER_PWM_MOD0    0x00000000  /* PWM triggers from PWM0    */
#define ADC_TRIGGER_PWM_MOD1    0x00000010  /* PWM triggers from PWM1    */

/******************************************************************************
*
* Values that can be passed to ADCSequenceStepConfigure as the ui32Config
* parameter.
*
******************************************************************************/
#define ADC_CTL_TS              0x00000080  /* Temperature sensor select      */
#define ADC_CTL_IE              0x00000040  /* Interrupt enable               */
#define ADC_CTL_END             0x00000020  /* Sequence end select            */
#define ADC_CTL_D               0x00000010  /* Differential select            */
#define ADC_CTL_CH0             0x00000000  /* Input channel 0                */
#define ADC_CTL_CH1             0x00000001  /* Input channel 1                */
#define ADC_CTL_CH2             0x00000002  /* Input channel 2                */
#define ADC_CTL_CH3             0x00000003  /* Input channel 3                */
#define ADC_CTL_CH4             0x00000004  /* Input channel 4                */
#define ADC_CTL_CH5             0x00000005  /* Input channel 5                */
#define ADC_CTL_CH6             0x00000006  /* Input channel 6                */
#define ADC_CTL_CH7             0x00000007  /* Input channel 7                */
#define ADC_CTL_CH8             0x00000008  /* Input channel 8                */
#define ADC_CTL_CH9             0x00000009  /* Input channel 9                */
#define ADC_CTL_CH10            0x0000000A  /* Input channel 10               */
#define ADC_CTL_CH11            0x0000000B  /* Input channel 11               */
#define ADC_CTL_CH12            0x0000000C  /* Input channel 12               */
#define ADC_CTL_CH13            0x0000000D  /* Input channel 13               */
#define ADC_CTL_CH14            0x0000000E  /* Input channel 14               */
#define ADC_CTL_CH15            0x0000000F  /* Input channel 15               */
#define ADC_CTL_CH16            0x00000100  /* Input channel 16               */
#define ADC_CTL_CH17            0x00000101  /* Input channel 17               */
#define ADC_CTL_CH18            0x00000102  /* Input channel 18               */
#define ADC_CTL_CH19            0x00000103  /* Input channel 19               */
#define ADC_CTL_CH20            0x00000104  /* Input channel 20               */
#define ADC_CTL_CH21            0x00000105  /* Input channel 21               */
#define ADC_CTL_CH22            0x00000106  /* Input channel 22               */
#define ADC_CTL_CH23            0x00000107  /* Input channel 23               */
#define ADC_CTL_CMP0            0x00080000  /* Select Comparator 0            */
#define ADC_CTL_CMP1            0x00090000  /* Select Comparator 1            */
#define ADC_CTL_CMP2            0x000A0000  /* Select Comparator 2            */
#define ADC_CTL_CMP3            0x000B0000  /* Select Comparator 3            */
#define ADC_CTL_CMP4            0x000C0000  /* Select Comparator 4            */
#define ADC_CTL_CMP5            0x000D0000  /* Select Comparator 5            */
#define ADC_CTL_CMP6            0x000E0000  /* Select Comparator 6            */
#define ADC_CTL_CMP7            0x000F0000  /* Select Comparator 7            */
#define ADC_CTL_SHOLD_4         0x00000000  /* Sample and hold 4 ADC clocks   */
#define ADC_CTL_SHOLD_8         0x00200000  /* Sample and hold 8 ADC clocks   */
#define ADC_CTL_SHOLD_16        0x00400000  /* Sample and hold 16 ADC clocks  */
#define ADC_CTL_SHOLD_32        0x00600000  /* Sample and hold 32 ADC clocks  */
#define ADC_CTL_SHOLD_64        0x00800000  /* Sample and hold 64 ADC clocks  */
#define ADC_CTL_SHOLD_128       0x00A00000  /* Sample and hold 128 ADC clocks */
#define ADC_CTL_SHOLD_256       0x00C00000  /* Sample and hold 256 ADC clocks */

/******************************************************************************
*
* Values that can be passed to ADCComparatorConfigure as part of the
* ui32Config parameter.
*
******************************************************************************/
#define ADC_COMP_TRIG_NONE      0x00000000  /* Trigger Disabled   */
#define ADC_COMP_TRIG_LOW_ALWAYS \
                                0x00001000  /* Trigger Low Always */
#define ADC_COMP_TRIG_LOW_ONCE  0x00001100  /* Trigger Low Once   */
#define ADC_COMP_TRIG_LOW_HALWAYS \
                                0x00001200  /* Trigger Low Always (Hysteresis) */
#define ADC_COMP_TRIG_LOW_HONCE 0x00001300  /* Trigger Low Once (Hysteresis) */
#define ADC_COMP_TRIG_MID_ALWAYS \
                                0x00001400  /* Trigger Mid Always */
#define ADC_COMP_TRIG_MID_ONCE  0x00001500  /* Trigger Mid Once */
#define ADC_COMP_TRIG_HIGH_ALWAYS \
                                0x00001C00  /* Trigger High Always */
#define ADC_COMP_TRIG_HIGH_ONCE 0x00001D00  /* Trigger High Once */
#define ADC_COMP_TRIG_HIGH_HALWAYS \
                                0x00001E00  /* Trigger High Always (Hysteresis) */
#define ADC_COMP_TRIG_HIGH_HONCE \
                                0x00001F00  /* Trigger High Once (Hysteresis) */

#define ADC_COMP_INT_NONE       0x00000000  /* Interrupt Disabled */
#define ADC_COMP_INT_LOW_ALWAYS \
                                0x00000010  /* Interrupt Low Always */
#define ADC_COMP_INT_LOW_ONCE   0x00000011  /* Interrupt Low Once */
#define ADC_COMP_INT_LOW_HALWAYS \
                                0x00000012  /* Interrupt Low Always */
                                            /* (Hysteresis) */
#define ADC_COMP_INT_LOW_HONCE  0x00000013  /* Interrupt Low Once (Hysteresis) */
#define ADC_COMP_INT_MID_ALWAYS \
                                0x00000014  /* Interrupt Mid Always */
#define ADC_COMP_INT_MID_ONCE   0x00000015  /* Interrupt Mid Once */
#define ADC_COMP_INT_HIGH_ALWAYS \
                                0x0000001C  /* Interrupt High Always */
#define ADC_COMP_INT_HIGH_ONCE  0x0000001D  /* Interrupt High Once */
#define ADC_COMP_INT_HIGH_HALWAYS \
                                0x0000001E  /* Interrupt High Always */
                                            /* (Hysteresis) */
#define ADC_COMP_INT_HIGH_HONCE \
                                0x0000001F  /* Interrupt High Once (Hysteresis) */

/******************************************************************************
*
* Values that can be used to modify the sequence number passed to
* ADCProcessorTrigger in order to get cross-module synchronous processor
* triggers.
*
******************************************************************************/
#define ADC_TRIGGER_WAIT        0x08000000  /* Wait for the synchronous trigger */
#define ADC_TRIGGER_SIGNAL      0x80000000  /* Signal the synchronous trigger   */

/******************************************************************************
*
* Values that can be passed to ADCPhaseDelaySet as the ui32Phase parameter and
* returned from ADCPhaseDelayGet.
*
******************************************************************************/
#define ADC_PHASE_0             0x00000000  /* 0 degrees     */
#define ADC_PHASE_22_5          0x00000001  /* 22.5 degrees  */
#define ADC_PHASE_45            0x00000002  /* 45 degrees    */
#define ADC_PHASE_67_5          0x00000003  /* 67.5 degrees  */
#define ADC_PHASE_90            0x00000004  /* 90 degrees    */
#define ADC_PHASE_112_5         0x00000005  /* 112.5 degrees */
#define ADC_PHASE_135           0x00000006  /* 135 degrees   */
#define ADC_PHASE_157_5         0x00000007  /* 157.5 degrees */
#define ADC_PHASE_180           0x00000008  /* 180 degrees   */
#define ADC_PHASE_202_5         0x00000009  /* 202.5 degrees */
#define ADC_PHASE_225           0x0000000A  /* 225 degrees   */
#define ADC_PHASE_247_5         0x0000000B  /* 247.5 degrees */
#define ADC_PHASE_270           0x0000000C  /* 270 degrees   */
#define ADC_PHASE_292_5         0x0000000D  /* 292.5 degrees */
#define ADC_PHASE_315           0x0000000E  /* 315 degrees   */
#define ADC_PHASE_337_5         0x0000000F  /* 337.5 degrees */

/******************************************************************************
*
* Values that can be passed to ADCReferenceSet as the ui32Ref parameter.
*
******************************************************************************/
#define ADC_REF_INT             0x00000000  /* Internal reference    */
#define ADC_REF_EXT_3V          0x00000001  /* External 3V reference */
#define ADC_REF_EXT_1V          0x00000003  /* External 1V reference */

/******************************************************************************
*
* Values that can be passed to ADCIntDisableEx(), ADCIntEnableEx(),
* ADCIntClearEx() and ADCIntStatusEx().
*
******************************************************************************/
#define ADC_INT_SS0             0x00000001
#define ADC_INT_SS1             0x00000002
#define ADC_INT_SS2             0x00000004
#define ADC_INT_SS3             0x00000008
#define ADC_INT_DMA_SS0         0x00000100
#define ADC_INT_DMA_SS1         0x00000200
#define ADC_INT_DMA_SS2         0x00000400
#define ADC_INT_DMA_SS3         0x00000800
#define ADC_INT_DCON_SS0        0x00010000
#define ADC_INT_DCON_SS1        0x00020000
#define ADC_INT_DCON_SS2        0x00040000
#define ADC_INT_DCON_SS3        0x00080000

/******************************************************************************
*
* Values that can be passed to ADCClockConfigSet() and ADCClockConfigGet().
*
******************************************************************************/
#define ADC_CLOCK_RATE_FULL     0x00000070
#define ADC_CLOCK_RATE_HALF     0x00000050
#define ADC_CLOCK_RATE_FOURTH   0x00000030
#define ADC_CLOCK_RATE_EIGHTH   0x00000010
#define ADC_CLOCK_SRC_PLL       0x00000000
#define ADC_CLOCK_SRC_PIOSC     0x00000001
#define ADC_CLOCK_SRC_ALTCLK    0x00000001
#define ADC_CLOCK_SRC_MOSC      0x00000002


/******************************************************************************
*                              End of file
*******************************************************************************/
#endif /* _ADC_H_ */
