#ifndef _FLASH_H_
#define _FLASH_H_
/******************************************************************************
*            Texas Instruments Incorporated. All rights reserved
*******************************************************************************
*                    File: Flash.h
*             Description: Flash Driver
*      Platform Dependent: no
*                   Notes:
******************************************************************************/

/******************************************************************************
*
* Values that can be passed to FlashProtectSet(), and returned by
* FlashProtectGet().
*
******************************************************************************/
typedef enum
{
    FlashReadWrite,                         /* Flash can be read and written */
    FlashReadOnly,                          /* Flash can only be read        */
    FlashExecuteOnly                        /* Flash can only be executed    */
}
enFlashProtection;

/******************************************************************************
*
* Values passed to FlashIntEnable(), FlashIntDisable() and FlashIntClear() and
* returned from FlashIntStatus().
*
******************************************************************************/
#define FLASH_INT_PROGRAM     0x00000002 /* Programming Interrupt Mask          */
#define FLASH_INT_ACCESS      0x00000001 /* Access Interrupt Mask               */
#define FLASH_INT_EEPROM      0x00000004 /* EEPROM Interrupt Mask               */
#define FLASH_INT_VOLTAGE_ERR 0x00000200 /* Voltage Error Interrupt Mask        */
#define FLASH_INT_DATA_ERR    0x00000400 /* Invalid Data Interrupt Mask         */
#define FLASH_INT_ERASE_ERR   0x00000800 /* Erase Error Interrupt Mask          */
#define FLASH_INT_PROGRAM_ERR 0x00002000 /* Program Verify Error Interrupt Mask */

/******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _FLASH_H_ */
