#ifndef _MCP2515_H_
#define _MCP2515_H_
/******************************************************************************
*                        EddeFlex All rights reserved
*******************************************************************************
*                    File: MCP2515.h
*             Description: MCP2515 driver
*      Platform Dependent: Std_Types.h
*                          SPI.h
*                          GPIO.h
*                 Version: 1
******************************************************************************/


/******************************************************************************
*                          MCP2515 CAN Bit Rate
******************************************************************************/
#define MCP2515_BitRate_1000kBPS    12U
#define MCP2515_BitRate_500kBPS     11U
#define MCP2515_BitRate_250kBPS     10U
#define MCP2515_BitRate_200kBPS     9U
#define MCP2515_BitRate_125kBPS     8U
#define MCP2515_BitRate_100kBPS     7U
#define MCP2515_BitRate_80kBPS      6U
#define MCP2515_BitRate_50kBPS      5U
#define MCP2515_BitRate_40kBPS      4U
#define MCP2515_BitRate_31k25BPS    3U
#define MCP2515_BitRate_20kBPS      2U
#define MCP2515_BitRate_10kBPS      1U
#define MCP2515_BitRate_5kBPS       0U


/******************************************************************************
*                       MCP2515 TX Buffers ID
******************************************************************************/
#define MCP2515_TX0_ID    0x00U
#define MCP2515_TX1_ID    0x01U
#define MCP2515_TX2_ID    0x02U


/******************************************************************************
*                        MCP2515 RX Buffers ID
******************************************************************************/
#define MCP2515_RX0_ID    0x00U
#define MCP2515_RX1_ID    0x01U


/******************************************************************************
*                         MCP2515 Interrupt Flags
******************************************************************************/
#define MCP2515_Int_MsgError    0x80U
#define MCP2515_Int_WakeUp      0x40U
#define MCP2515_Int_BusError    0x20U
#define MCP2515_Int_TX2Buff     0x10U
#define MCP2515_Int_TX1Buff     0x08U
#define MCP2515_Int_TX0Buff     0x04U
#define MCP2515_Int_RX1Buff     0x02U
#define MCP2515_Int_RX0Buff     0x01U


/******************************************************************************
*                        MCP2515 Status Flags
******************************************************************************/
#define MCP2515_Stat_TX2Buff     0x80U
#define MCP2515_Stat_TX2Req      0x40U
#define MCP2515_Stat_TX1Buff     0x20U
#define MCP2515_Stat_TX1Req      0x10U
#define MCP2515_Stat_TX0Buff     0x08U
#define MCP2515_Stat_TX0Req      0x04U
#define MCP2515_Stat_RX1Buff     0x02U
#define MCP2515_Stat_RX0Buff     0x01U


/******************************************************************************
*                     Functions prototype
******************************************************************************/
extern void  MCP2515_SW_Reset(uint8 u8CSPin);
extern void  MCP2515_Init(uint8 u8CSPin, uint8 u8BitRate);
extern void  MCP2515_Enable(uint8 u8CSPin);
extern void  MCP2515_Disable(uint8 u8CSPin);
extern void  MCP2515_CANMessageSet(uint8 u8CSPin, uint8 u8BuffId, strCANMsgObject *psMsgObject);
extern void  MCP2515_CANMessageGet(uint8 u8CSPin, uint8 u8BuffId, strCANMsgObject *psMsgObject);
extern uint8 MCP2515_CANStatusGet(uint8 u8CSPin);
extern void  MCP2515_CANIntClear(uint8 u8CSPin, uint8 u8IntFlags);
extern void  MCP2515_CANIntEnable(uint8 u8CSPin, uint8 u8IntFlags);
extern void  MCP2515_CANIntDisable(uint8 u8CSPin, uint8 u8IntFlags);
extern uint8 MCP2515_CANIntStatus(uint8 u8CSPin);


/******************************************************************************
*                             File History
*******************************************************************************
* 3/4/2017    YAli    -Initial Version.
*******************************************************************************
*******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _MCP2515_H_ */
