#ifndef _HW_MCP2515_H_
#define _HW_MCP2515_H_
/******************************************************************************
*                        EddeFlex All rights reserved
*******************************************************************************
*                    File: hw_MCP2515.h
*             Description: MCP2515 MACROS
*      Platform Dependent: -
*                 Version: 1
******************************************************************************/


/******************************************************************************
*                         MCP2515 SPI Commands
******************************************************************************/
#define MCP2515_REST_CMD           0xC0U
#define MCP2515_READ_CMD           0x03U
#define MCP2515_Read_RXB_CMD       0x90U
#define MCP2515_WRITE_CMD          0x02U
#define MCP2515_WRITE_TXB_CMD      0x40U
#define MCP2515_RTS_CMD            0x80U
#define MCP2515_READ_STATUS_CMD    0xA0U
#define MCP2515_BIT_MODIFY_CMD     0x05U


/******************************************************************************
*                        MCP2515 SPI Used Macros
******************************************************************************/
#define MCP2515_MAX_BIT_RATE_NUMBER    13U
#define MCP2515_DUMMY_DATA             0x00U
#define MCP2515_BIT_CLEAR              0x00U
#define MCP2515_BIT_SET                0xFFU


/******************************************************************************
*                           MCP2515 Modes
******************************************************************************/
#define MCP2515_MODE_LISTEN        0x60U
#define MCP2515_MODE_LOOPBACK      0x40U
#define MCP2515_MODE_CFG           0x80U
#define MCP2515_MODE_NORMAL        0x00U
#define MCP2515_MODE_SLEEP         0x20U


/******************************************************************************
*                           MCP2515 registers
******************************************************************************/
#define MCP2515_RXF0SIDH           0x00U
#define MCP2515_RXF0SIDL           0x01U
#define MCP2515_RXF0EID8           0x02U
#define MCP2515_RXF0EID0           0x03U
#define MCP2515_RXF1SIDH           0x04U
#define MCP2515_RXF1SIDL           0x05U
#define MCP2515_RXF1EID8           0x06U
#define MCP2515_RXF1EID0           0x07U
#define MCP2515_RXF2SIDH           0x08U
#define MCP2515_RXF2SIDL           0x09U
#define MCP2515_RXF2EID8           0x0AU
#define MCP2515_RXF2EID0           0x0BU
#define MCP2515_CANSTAT            0x0EU
#define MCP2515_CANCTRL            0x0FU
#define MCP2515_RXF3SIDH           0x10U
#define MCP2515_RXF3SIDL           0x11U
#define MCP2515_RXF3EID8           0x12U
#define MCP2515_RXF3EID0           0x13U
#define MCP2515_RXF4SIDH           0x14U
#define MCP2515_RXF4SIDL           0x15U
#define MCP2515_RXF4EID8           0x16U
#define MCP2515_RXF4EID0           0x17U
#define MCP2515_RXF5SIDH           0x18U
#define MCP2515_RXF5SIDL           0x19U
#define MCP2515_RXF5EID8           0x1AU
#define MCP2515_RXF5EID0           0x1BU
#define MCP2515_TEC                0x1CU
#define MCP2515_REC                0x1DU
#define MCP2515_RXM0SIDH           0x20U
#define MCP2515_RXM0SIDL           0x21U
#define MCP2515_RXM0EID8           0x22U
#define MCP2515_RXM0EID0           0x23U
#define MCP2515_RXM1SIDH           0x24U
#define MCP2515_RXM1SIDL           0x25U
#define MCP2515_RXM1EID8           0x26U
#define MCP2515_RXM1EID0           0x27U
#define MCP2515_CNF3               0x28U
#define MCP2515_CNF2               0x29U
#define MCP2515_CNF1               0x2AU
#define MCP2515_CANINTE            0x2BU
#define MCP2515_CANINTF            0x2CU
#define MCP2515_EFLG               0x2DU
#define MCP2515_TXB0CTRL           0x30U
#define MCP2515_TXB1CTRL           0x40U
#define MCP2515_TXB2CTRL           0x50U
#define MCP2515_RXB0CTRL           0x60U
#define MCP2515_RXB0SIDH           0x61U
#define MCP2515_RXB1CTRL           0x70U
#define MCP2515_RXB1SIDH           0x71U



/******************************************************************************
*                        MCP2515 CAN Bit Rates
******************************************************************************/
#define MCP2515_16MHz_1000kBPS_CFG1    0x00U
#define MCP2515_16MHz_1000kBPS_CFG2    0xD0U
#define MCP2515_16MHz_1000kBPS_CFG3    0x82U
                                       
#define MCP2515_16MHz_500kBPS_CFG1     0x00U
#define MCP2515_16MHz_500kBPS_CFG2     0xF0U
#define MCP2515_16MHz_500kBPS_CFG3     0x86U
                                       
#define MCP2515_16MHz_250kBPS_CFG1     0x41U
#define MCP2515_16MHz_250kBPS_CFG2     0xF1U
#define MCP2515_16MHz_250kBPS_CFG3     0x85U
                                       
#define MCP2515_16MHz_200kBPS_CFG1     0x01U
#define MCP2515_16MHz_200kBPS_CFG2     0xFAU
#define MCP2515_16MHz_200kBPS_CFG3     0x87U
                                       
#define MCP2515_16MHz_125kBPS_CFG1     0x03U
#define MCP2515_16MHz_125kBPS_CFG2     0xF0U
#define MCP2515_16MHz_125kBPS_CFG3     0x86U
                                       
#define MCP2515_16MHz_100kBPS_CFG1     0x03U
#define MCP2515_16MHz_100kBPS_CFG2     0xFAU
#define MCP2515_16MHz_100kBPS_CFG3     0x87U
                                       
#define MCP2515_16MHz_80kBPS_CFG1      0x03U
#define MCP2515_16MHz_80kBPS_CFG2      0xFFU
#define MCP2515_16MHz_80kBPS_CFG3      0x87U
                                       
#define MCP2515_16MHz_50kBPS_CFG1      0x07U
#define MCP2515_16MHz_50kBPS_CFG2      0xFAU
#define MCP2515_16MHz_50kBPS_CFG3      0x87U
                                   
#define MCP2515_16MHz_40kBPS_CFG1      0x07U
#define MCP2515_16MHz_40kBPS_CFG2      0xFFU
#define MCP2515_16MHz_40kBPS_CFG3      0x87U
                                       
#define MCP2515_16MHz_31k25BPS_CFG1    0x0FU
#define MCP2515_16MHz_31k25BPS_CFG2    0xF1U
#define MCP2515_16MHz_31k25BPS_CFG3    0x85U
                                       
#define MCP2515_16MHz_20kBPS_CFG1      0x0FU
#define MCP2515_16MHz_20kBPS_CFG2      0xFFU
#define MCP2515_16MHz_20kBPS_CFG3      0x87U
                                       
#define MCP2515_16MHz_10kBPS_CFG1      0x1FU
#define MCP2515_16MHz_10kBPS_CFG2      0xFFU
#define MCP2515_16MHz_10kBPS_CFG3      0x87U
                                       
#define MCP2515_16MHz_5kBPS_CFG1       0x3FU
#define MCP2515_16MHz_5kBPS_CFG2       0xFFU
#define MCP2515_16MHz_5kBPS_CFG3       0x87U


/******************************************************************************
*                             File History
*******************************************************************************
* 20/3/2017    YAli    -Initial Version.
*******************************************************************************
*******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _HW_MCP2515_H_ */
