#ifndef _ROM_H_
#define _ROM_H_
/*******************************************************************************
*             Texas Instruments Incorporated. All rights reserved
********************************************************************************
*                    File: ROM.h
*             Description: ROM APIs memory map
*      Platform Dependent: no
*                   Notes:
*******************************************************************************/


/*******************************************************************************
*
* Pointers to the main API tables.
*
******************************************************************************/
#define ROM_APITABLE            ((uint32 *)0x01000010)
#define ROM_VERSION             (ROM_APITABLE[0])
#define ROM_UARTTABLE           ((uint32 *)(ROM_APITABLE[1]))
#define ROM_SSITABLE            ((uint32 *)(ROM_APITABLE[2]))
#define ROM_I2CTABLE            ((uint32 *)(ROM_APITABLE[3]))
#define ROM_GPIOTABLE           ((uint32 *)(ROM_APITABLE[4]))
#define ROM_ADCTABLE            ((uint32 *)(ROM_APITABLE[5]))
#define ROM_COMPARATORTABLE     ((uint32 *)(ROM_APITABLE[6]))
#define ROM_FLASHTABLE          ((uint32 *)(ROM_APITABLE[7]))
#define ROM_PWMTABLE            ((uint32 *)(ROM_APITABLE[8]))
#define ROM_QEITABLE            ((uint32 *)(ROM_APITABLE[9]))
#define ROM_SYSTICKTABLE        ((uint32 *)(ROM_APITABLE[10]))
#define ROM_TIMERTABLE          ((uint32 *)(ROM_APITABLE[11]))
#define ROM_WATCHDOGTABLE       ((uint32 *)(ROM_APITABLE[12]))
#define ROM_SYSCTLTABLE         ((uint32 *)(ROM_APITABLE[13]))
#define ROM_INTERRUPTTABLE      ((uint32 *)(ROM_APITABLE[14]))
#define ROM_USBTABLE            ((uint32 *)(ROM_APITABLE[16]))
#define ROM_UDMATABLE           ((uint32 *)(ROM_APITABLE[17]))
#define ROM_CANTABLE            ((uint32 *)(ROM_APITABLE[18]))
#define ROM_HIBERNATETABLE      ((uint32 *)(ROM_APITABLE[19]))
#define ROM_MPUTABLE            ((uint32 *)(ROM_APITABLE[20]))
#define ROM_SOFTWARETABLE       ((uint32 *)(ROM_APITABLE[21]))
#define ROM_EPITABLE            ((uint32 *)(ROM_APITABLE[23]))
#define ROM_EEPROMTABLE         ((uint32 *)(ROM_APITABLE[24]))
#define ROM_FPUTABLE            ((uint32 *)(ROM_APITABLE[26]))
#define ROM_SMBUSTABLE          ((uint32 *)(ROM_APITABLE[29]))
#define ROM_SYSEXCTABLE         ((uint32 *)(ROM_APITABLE[30]))
#define ROM_ONEWIRETABLE        ((uint32 *)(ROM_APITABLE[34]))
#define ROM_SPIFLASHTABLE       ((uint32 *)(ROM_APITABLE[38]))
#define ROM_LCDTABLE            ((uint32 *)(ROM_APITABLE[41]))
#define ROM_EMACTABLE           ((uint32 *)(ROM_APITABLE[42]))
#define ROM_AESTABLE            ((uint32 *)(ROM_APITABLE[43]))
#define ROM_CRCTABLE            ((uint32 *)(ROM_APITABLE[44]))
#define ROM_DESTABLE            ((uint32 *)(ROM_APITABLE[45]))
#define ROM_SHAMD5TABLE         ((uint32 *)(ROM_APITABLE[46]))

/******************************************************************************
*
* Macros for calling ROM functions in the ADC API.
*
******************************************************************************/
#define ROM_ADCSequenceDataGet                                                \
        ((sint32 (*)(uint32 ui32Base,                                         \
                      uint32 ui32SequenceNum,                                 \
                      uint32 *pui32Buffer))ROM_ADCTABLE[0])
#define ROM_ADCIntDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[1])
#define ROM_ADCIntEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[2])
#define ROM_ADCIntStatus                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32SequenceNum,                                \
                       boolean bMasked))ROM_ADCTABLE[3])
#define ROM_ADCIntClear                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[4])
#define ROM_ADCSequenceEnable                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[5])
#define ROM_ADCSequenceDisable                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[6])
#define ROM_ADCSequenceConfigure                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum,                                    \
                   uint32 ui32Trigger,                                        \
                   uint32 ui32Priority))ROM_ADCTABLE[7])
#define ROM_ADCSequenceStepConfigure                                          \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum,                                    \
                   uint32 ui32Step,                                           \
                   uint32 ui32Config))ROM_ADCTABLE[8])
#define ROM_ADCSequenceOverflow                                               \
        ((sint32 (*)(uint32 ui32Base,                                         \
                      uint32 ui32SequenceNum))ROM_ADCTABLE[9])
#define ROM_ADCSequenceOverflowClear                                          \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[10])
#define ROM_ADCSequenceUnderflow                                              \
        ((sint32 (*)(uint32 ui32Base,                                         \
                      uint32 ui32SequenceNum))ROM_ADCTABLE[11])
#define ROM_ADCSequenceUnderflowClear                                         \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[12])
#define ROM_ADCProcessorTrigger                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[13])
#define ROM_ADCHardwareOversampleConfigure                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Factor))ROM_ADCTABLE[14])
#define ROM_ADCComparatorConfigure                                            \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp,                                           \
                   uint32 ui32Config))ROM_ADCTABLE[15])
#define ROM_ADCComparatorRegionSet                                            \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp,                                           \
                   uint32 ui32LowRef,                                         \
                   uint32 ui32HighRef))ROM_ADCTABLE[16])
#define ROM_ADCComparatorReset                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp,                                           \
                   boolean bTrigger,                                             \
                   boolean bInterrupt))ROM_ADCTABLE[17])
#define ROM_ADCComparatorIntDisable                                           \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[18])
#define ROM_ADCComparatorIntEnable                                            \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SequenceNum))ROM_ADCTABLE[19])
#define ROM_ADCComparatorIntStatus                                            \
        ((uint32 (*)(uint32 ui32Base))ROM_ADCTABLE[20])
#define ROM_ADCComparatorIntClear                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Status))ROM_ADCTABLE[21])
#define ROM_ADCReferenceSet                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Ref))ROM_ADCTABLE[22])
#define ROM_ADCReferenceGet                                                   \
        ((uint32 (*)(uint32 ui32Base))ROM_ADCTABLE[23])
#define ROM_ADCPhaseDelaySet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Phase))ROM_ADCTABLE[24])
#define ROM_ADCPhaseDelayGet                                                  \
        ((uint32 (*)(uint32 ui32Base))ROM_ADCTABLE[25])

        
/******************************************************************************
*
* Macros for calling ROM functions in the CAN API.
*
******************************************************************************/
#define ROM_CANIntClear                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntClr))ROM_CANTABLE[0])
#define ROM_CANInit                                                           \
        ((void (*)(uint32 ui32Base))ROM_CANTABLE[1])
#define ROM_CANEnable                                                         \
        ((void (*)(uint32 ui32Base))ROM_CANTABLE[2])
#define ROM_CANDisable                                                        \
        ((void (*)(uint32 ui32Base))ROM_CANTABLE[3])
#define ROM_CANBitTimingSet                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   tCANBitClkParms *psClkParms))ROM_CANTABLE[4])
#define ROM_CANBitTimingGet                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   tCANBitClkParms *psClkParms))ROM_CANTABLE[5])
#define ROM_CANMessageSet                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32ObjID,                                          \
                   strCANMsgObject *psMsgObject,                              \
                   enMsgObjType eMsgType))ROM_CANTABLE[6])
#define ROM_CANMessageGet                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32ObjID,                                          \
                   strCANMsgObject *psMsgObject,                              \
                   boolean bClrPendingInt))ROM_CANTABLE[7])
#define ROM_CANStatusGet                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       enCANStsReg eStatusReg))ROM_CANTABLE[8])
#define ROM_CANMessageClear                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32ObjID))ROM_CANTABLE[9])
#define ROM_CANIntEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_CANTABLE[10])
#define ROM_CANIntDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_CANTABLE[11])
#define ROM_CANIntStatus                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       enCANIntStsReg eIntStsReg))ROM_CANTABLE[12])
#define ROM_CANRetryGet                                                       \
        ((boolean (*)(uint32 ui32Base))ROM_CANTABLE[13])
#define ROM_CANRetrySet                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   boolean bAutoRetry))ROM_CANTABLE[14])
#define ROM_CANErrCntrGet                                                     \
        ((boolean (*)(uint32 ui32Base,                                           \
                   uint32 *pui32RxCount,                                      \
                   uint32 *pui32TxCount))ROM_CANTABLE[15])
#define ROM_CANBitRateSet                                                     \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32SourceClock,                                \
                       uint32 ui32BitRate))ROM_CANTABLE[16])


/******************************************************************************
*
* Macros for calling ROM functions in the Comparator API.
*
******************************************************************************/
#define ROM_ComparatorIntClear                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp))ROM_COMPARATORTABLE[0])
#define ROM_ComparatorConfigure                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp,                                           \
                   uint32 ui32Config))ROM_COMPARATORTABLE[1])
#define ROM_ComparatorRefSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Ref))ROM_COMPARATORTABLE[2])
#define ROM_ComparatorValueGet                                                \
        ((boolean (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp))ROM_COMPARATORTABLE[3])
#define ROM_ComparatorIntEnable                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp))ROM_COMPARATORTABLE[4])
#define ROM_ComparatorIntDisable                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp))ROM_COMPARATORTABLE[5])
#define ROM_ComparatorIntStatus                                               \
        ((boolean (*)(uint32 ui32Base,                                           \
                   uint32 ui32Comp,                                           \
                   boolean bMasked))ROM_COMPARATORTABLE[6])

                   

/******************************************************************************
*
* Macros for calling ROM functions in the EEPROM API.
*
******************************************************************************/
#define ROM_EEPROMRead                                                        \
        ((void (*)(uint32 *pui32Data,                                         \
                   uint32 ui32Address,                                        \
                   uint32 ui32Count))ROM_EEPROMTABLE[0])
#define ROM_EEPROMBlockCountGet                                               \
        ((uint32 (*)(void))ROM_EEPROMTABLE[1])
#define ROM_EEPROMBlockHide                                                   \
        ((void (*)(uint32 ui32Block))ROM_EEPROMTABLE[2])
#define ROM_EEPROMBlockLock                                                   \
        ((uint32 (*)(uint32 ui32Block))ROM_EEPROMTABLE[3])
#define ROM_EEPROMBlockPasswordSet                                            \
        ((uint32 (*)(uint32 ui32Block,                                        \
                       uint32 *pui32Password,                                 \
                       uint32 ui32Count))ROM_EEPROMTABLE[4])
#define ROM_EEPROMBlockProtectGet                                             \
        ((uint32 (*)(uint32 ui32Block))ROM_EEPROMTABLE[5])
#define ROM_EEPROMBlockProtectSet                                             \
        ((uint32 (*)(uint32 ui32Block,                                        \
                       uint32 ui32Protect))ROM_EEPROMTABLE[6])
#define ROM_EEPROMBlockUnlock                                                 \
        ((uint32 (*)(uint32 ui32Block,                                        \
                       uint32 *pui32Password,                                 \
                       uint32 ui32Count))ROM_EEPROMTABLE[7])
#define ROM_EEPROMIntClear                                                    \
        ((void (*)(uint32 ui32IntFlags))ROM_EEPROMTABLE[8])
#define ROM_EEPROMIntDisable                                                  \
        ((void (*)(uint32 ui32IntFlags))ROM_EEPROMTABLE[9])
#define ROM_EEPROMIntEnable                                                   \
        ((void (*)(uint32 ui32IntFlags))ROM_EEPROMTABLE[10])
#define ROM_EEPROMIntStatus                                                   \
        ((uint32 (*)(boolean bMasked))ROM_EEPROMTABLE[11])
#define ROM_EEPROMMassErase                                                   \
        ((uint32 (*)(void))ROM_EEPROMTABLE[12])
#define ROM_EEPROMProgram                                                     \
        ((uint32 (*)(uint32 *pui32Data,                                       \
                       uint32 ui32Address,                                    \
                       uint32 ui32Count))ROM_EEPROMTABLE[13])
#define ROM_EEPROMProgramNonBlocking                                          \
        ((uint32 (*)(uint32 ui32Data,                                         \
                       uint32 ui32Address))ROM_EEPROMTABLE[14])
#define ROM_EEPROMSizeGet                                                     \
        ((uint32 (*)(void))ROM_EEPROMTABLE[15])
#define ROM_EEPROMStatusGet                                                   \
        ((uint32 (*)(void))ROM_EEPROMTABLE[16])
#define ROM_EEPROMInit                                                        \
        ((uint32 (*)(void))ROM_EEPROMTABLE[17])

        
/******************************************************************************
*
* Macros for calling ROM functions in the Flash API.
*
******************************************************************************/
#define ROM_FlashProgram                                                      \
        ((sint32 (*)(uint32 *pui32Data,                                       \
                      uint32 ui32Address,                                     \
                      uint32 ui32Count))ROM_FLASHTABLE[0])
#define ROM_FlashErase                                                        \
        ((sint32 (*)(uint32 ui32Address))ROM_FLASHTABLE[3])
#define ROM_FlashProtectGet                                                   \
        ((enFlashProtection (*)(uint32 ui32Address))ROM_FLASHTABLE[4])
#define ROM_FlashProtectSet                                                   \
        ((sint32 (*)(uint32 ui32Address,                                      \
                      enFlashProtection eProtect))ROM_FLASHTABLE[5])
#define ROM_FlashProtectSave                                                  \
        ((sint32 (*)(void))ROM_FLASHTABLE[6])
#define ROM_FlashUserGet                                                      \
        ((sint32 (*)(uint32 *pui32User0,                                      \
                      uint32 *pui32User1))ROM_FLASHTABLE[7])
#define ROM_FlashUserSet                                                      \
        ((sint32 (*)(uint32 ui32User0,                                        \
                      uint32 ui32User1))ROM_FLASHTABLE[8])
#define ROM_FlashUserSave                                                     \
        ((sint32 (*)(void))ROM_FLASHTABLE[9])
#define ROM_FlashIntEnable                                                    \
        ((void (*)(uint32 ui32IntFlags))ROM_FLASHTABLE[10])
#define ROM_FlashIntDisable                                                   \
        ((void (*)(uint32 ui32IntFlags))ROM_FLASHTABLE[11])
#define ROM_FlashIntStatus                                                    \
        ((uint32 (*)(boolean bMasked))ROM_FLASHTABLE[12])
#define ROM_FlashIntClear                                                     \
        ((void (*)(uint32 ui32IntFlags))ROM_FLASHTABLE[13])

/******************************************************************************
*
* Macros for calling ROM functions in the FPU API.
*
******************************************************************************/
#define ROM_FPUEnable                                                         \
        ((void (*)(void))ROM_FPUTABLE[0])
#define ROM_FPUDisable                                                        \
        ((void (*)(void))ROM_FPUTABLE[1])
#define ROM_FPUFlushToZeroModeSet                                             \
        ((void (*)(uint32 ui32Mode))ROM_FPUTABLE[2])
#define ROM_FPUHalfPrecisionModeSet                                           \
        ((void (*)(uint32 ui32Mode))ROM_FPUTABLE[3])
#define ROM_FPULazyStackingEnable                                             \
        ((void (*)(void))ROM_FPUTABLE[4])
#define ROM_FPUNaNModeSet                                                     \
        ((void (*)(uint32 ui32Mode))ROM_FPUTABLE[5])
#define ROM_FPURoundingModeSet                                                \
        ((void (*)(uint32 ui32Mode))ROM_FPUTABLE[6])
#define ROM_FPUStackingDisable                                                \
        ((void (*)(void))ROM_FPUTABLE[7])
#define ROM_FPUStackingEnable                                                 \
        ((void (*)(void))ROM_FPUTABLE[8])

/******************************************************************************
*
* Macros for calling ROM functions in the GPIO API.
*
******************************************************************************/
#define ROM_GPIOPinWrite                                                      \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins,                                             \
                   uint8 ui8Val))ROM_GPIOTABLE[0])
#define ROM_GPIODirModeSet                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins,                                             \
                   uint32 ui32PinIO))ROM_GPIOTABLE[1])
#define ROM_GPIODirModeGet                                                    \
        ((uint32 (*)(uint32 ui32Port,                                         \
                       uint8 ui8Pin))ROM_GPIOTABLE[2])
#define ROM_GPIOIntTypeSet                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins,                                             \
                   uint32 ui32IntType))ROM_GPIOTABLE[3])
#define ROM_GPIOIntTypeGet                                                    \
        ((uint32 (*)(uint32 ui32Port,                                         \
                       uint8 ui8Pin))ROM_GPIOTABLE[4])
#define ROM_GPIOPadConfigSet                                                  \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins,                                             \
                   uint32 ui32Strength,                                       \
                   uint32 ui32PadType))ROM_GPIOTABLE[5])
#define ROM_GPIOPadConfigGet                                                  \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pin,                                              \
                   uint32 *pui32Strength,                                     \
                   uint32 *pui32PadType))ROM_GPIOTABLE[6])
#define ROM_GPIOPinRead                                                       \
        ((sint32 (*)(uint32 ui32Port,                                         \
                      uint8 ui8Pins))ROM_GPIOTABLE[11])
#define ROM_GPIOPinTypeCAN                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[12])
#define ROM_GPIOPinTypeComparator                                             \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[13])
#define ROM_GPIOPinTypeGPIOInput                                              \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[14])
#define ROM_GPIOPinTypeGPIOOutput                                             \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[15])
#define ROM_GPIOPinTypeI2C                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[16])
#define ROM_GPIOPinTypePWM                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[17])
#define ROM_GPIOPinTypeQEI                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[18])
#define ROM_GPIOPinTypeSSI                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[19])
#define ROM_GPIOPinTypeTimer                                                  \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[20])
#define ROM_GPIOPinTypeUART                                                   \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[21])
#define ROM_GPIOPinTypeGPIOOutputOD                                           \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[22])
#define ROM_GPIOPinTypeADC                                                    \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[23])
#define ROM_GPIOPinTypeUSBDigital                                             \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[24])
#define ROM_GPIOPinConfigure                                                  \
        ((void (*)(uint32 ui32PinConfig))ROM_GPIOTABLE[26])
#define ROM_GPIOPinTypeUSBAnalog                                              \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[28])
#define ROM_GPIODMATriggerEnable                                              \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[31])
#define ROM_GPIODMATriggerDisable                                             \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[32])
#define ROM_GPIOADCTriggerEnable                                              \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[33])
#define ROM_GPIOADCTriggerDisable                                             \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[34])
#define ROM_GPIOPinTypeI2CSCL                                                 \
        ((void (*)(uint32 ui32Port,                                           \
                   uint8 ui8Pins))ROM_GPIOTABLE[39])

/******************************************************************************
*
* Macros for calling ROM functions in the Hibernate API.
*
******************************************************************************/
#define ROM_HibernateIntClear                                                 \
        ((void (*)(uint32 ui32IntFlags))ROM_HIBERNATETABLE[0])
#define ROM_HibernateEnableExpClk                                             \
        ((void (*)(uint32 ui32HibClk))ROM_HIBERNATETABLE[1])
#define ROM_HibernateDisable                                                  \
        ((void (*)(void))ROM_HIBERNATETABLE[2])
#define ROM_HibernateRTCEnable                                                \
        ((void (*)(void))ROM_HIBERNATETABLE[4])
#define ROM_HibernateRTCDisable                                               \
        ((void (*)(void))ROM_HIBERNATETABLE[5])
#define ROM_HibernateWakeSet                                                  \
        ((void (*)(uint32 ui32WakeFlags))ROM_HIBERNATETABLE[6])
#define ROM_HibernateWakeGet                                                  \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[7])
#define ROM_HibernateLowBatSet                                                \
        ((void (*)(uint32 ui32LowBatFlags))ROM_HIBERNATETABLE[8])
#define ROM_HibernateLowBatGet                                                \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[9])
#define ROM_HibernateRTCSet                                                   \
        ((void (*)(uint32 ui32RTCValue))ROM_HIBERNATETABLE[10])
#define ROM_HibernateRTCGet                                                   \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[11])
#define ROM_HibernateRTCTrimSet                                               \
        ((void (*)(uint32 ui32Trim))ROM_HIBERNATETABLE[16])
#define ROM_HibernateRTCTrimGet                                               \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[17])
#define ROM_HibernateDataSet                                                  \
        ((void (*)(uint32 *pui32Data,                                         \
                   uint32 ui32Count))ROM_HIBERNATETABLE[18])
#define ROM_HibernateDataGet                                                  \
        ((void (*)(uint32 *pui32Data,                                         \
                   uint32 ui32Count))ROM_HIBERNATETABLE[19])
#define ROM_HibernateRequest                                                  \
        ((void (*)(void))ROM_HIBERNATETABLE[20])
#define ROM_HibernateIntEnable                                                \
        ((void (*)(uint32 ui32IntFlags))ROM_HIBERNATETABLE[21])
#define ROM_HibernateIntDisable                                               \
        ((void (*)(uint32 ui32IntFlags))ROM_HIBERNATETABLE[22])
#define ROM_HibernateIntStatus                                                \
        ((uint32 (*)(boolean bMasked))ROM_HIBERNATETABLE[23])
#define ROM_HibernateIsActive                                                 \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[24])
#define ROM_HibernateRTCSSGet                                                 \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[27])
#define ROM_HibernateClockConfig                                              \
        ((void (*)(uint32 ui32Config))ROM_HIBERNATETABLE[28])
#define ROM_HibernateBatCheckStart                                            \
        ((void (*)(void))ROM_HIBERNATETABLE[29])
#define ROM_HibernateBatCheckDone                                             \
        ((uint32 (*)(void))ROM_HIBERNATETABLE[30])

/******************************************************************************
*
* Macros for calling ROM functions in the I2C API.
*
******************************************************************************/
#define ROM_I2CMasterDataPut                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint8 ui8Data))ROM_I2CTABLE[0])
#define ROM_I2CMasterInitExpClk                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32I2CClk,                                         \
                   boolean bFast))ROM_I2CTABLE[1])
#define ROM_I2CMasterEnable                                                   \
        ((void (*)(uint32 ui32Base))ROM_I2CTABLE[3])
#define ROM_I2CMasterDisable                                                  \
        ((void (*)(uint32 ui32Base))ROM_I2CTABLE[5])
#define ROM_I2CMasterIntEnable                                                \
        ((void (*)(uint32 ui32Base))ROM_I2CTABLE[7])
#define ROM_I2CMasterIntDisable                                               \
        ((void (*)(uint32 ui32Base))ROM_I2CTABLE[9])
#define ROM_I2CMasterIntStatus                                                \
        ((boolean (*)(uint32 ui32Base,                                           \
                   boolean bMasked))ROM_I2CTABLE[11])
#define ROM_I2CMasterIntClear                                                 \
        ((void (*)(uint32 ui32Base))ROM_I2CTABLE[13])
#define ROM_I2CMasterSlaveAddrSet                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint8 ui8SlaveAddr,                                        \
                   boolean bReceive))ROM_I2CTABLE[15])
#define ROM_I2CMasterBusy                                                     \
        ((boolean (*)(uint32 ui32Base))ROM_I2CTABLE[16])
#define ROM_I2CMasterBusBusy                                                  \
        ((boolean (*)(uint32 ui32Base))ROM_I2CTABLE[17])
#define ROM_I2CMasterControl                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Cmd))ROM_I2CTABLE[18])
#define ROM_I2CMasterErr                                                      \
        ((uint32 (*)(uint32 ui32Base))ROM_I2CTABLE[19])
#define ROM_I2CMasterDataGet                                                  \
        ((uint32 (*)(uint32 ui32Base))ROM_I2CTABLE[20])
#define ROM_UpdateI2C                                                         \
        ((void (*)(void))ROM_I2CTABLE[24])
#define ROM_I2CMasterIntEnableEx                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_I2CTABLE[29])
#define ROM_I2CMasterIntDisableEx                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_I2CTABLE[30])
#define ROM_I2CMasterIntStatusEx                                              \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_I2CTABLE[31])
#define ROM_I2CMasterIntClearEx                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_I2CTABLE[32])
#define ROM_I2CMasterTimeoutSet                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Value))ROM_I2CTABLE[33])
#define ROM_I2CMasterLineStateGet                                             \
        ((uint32 (*)(uint32 ui32Base))ROM_I2CTABLE[38])

/******************************************************************************
*
* Macros for calling ROM functions in the Interrupt API.
*
******************************************************************************/
#define ROM_IntEnable                                                         \
        ((void (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[0])
#define ROM_IntMasterEnable                                                   \
        ((boolean (*)(void))ROM_INTERRUPTTABLE[1])
#define ROM_IntMasterDisable                                                  \
        ((boolean (*)(void))ROM_INTERRUPTTABLE[2])
#define ROM_IntDisable                                                        \
        ((void (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[3])
#define ROM_IntPriorityGroupingSet                                            \
        ((void (*)(uint32 ui32Bits))ROM_INTERRUPTTABLE[4])
#define ROM_IntPriorityGroupingGet                                            \
        ((uint32 (*)(void))ROM_INTERRUPTTABLE[5])
#define ROM_IntPrioritySet                                                    \
        ((void (*)(uint32 ui32Interrupt,                                      \
                   uint8 ui8Priority))ROM_INTERRUPTTABLE[6])
#define ROM_IntPriorityGet                                                    \
        ((sint32 (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[7])
#define ROM_IntPendSet                                                        \
        ((void (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[8])
#define ROM_IntPendClear                                                      \
        ((void (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[9])
#define ROM_IntPriorityMaskSet                                                \
        ((void (*)(uint32 ui32PriorityMask))ROM_INTERRUPTTABLE[10])
#define ROM_IntPriorityMaskGet                                                \
        ((uint32 (*)(void))ROM_INTERRUPTTABLE[11])

#define ROM_IntIsEnabled                                                      \
        ((uint32 (*)(uint32 ui32Interrupt))ROM_INTERRUPTTABLE[12])


/******************************************************************************
*
* Macros for calling ROM functions in the MPU API.
*
******************************************************************************/
#define ROM_MPUEnable                                                         \
        ((void (*)(uint32 ui32MPUConfig))ROM_MPUTABLE[0])
#define ROM_MPUDisable                                                        \
        ((void (*)(void))ROM_MPUTABLE[1])
#define ROM_MPURegionCountGet                                                 \
        ((uint32 (*)(void))ROM_MPUTABLE[2])
#define ROM_MPURegionEnable                                                   \
        ((void (*)(uint32 ui32Region))ROM_MPUTABLE[3])
#define ROM_MPURegionDisable                                                  \
        ((void (*)(uint32 ui32Region))ROM_MPUTABLE[4])
#define ROM_MPURegionSet                                                      \
        ((void (*)(uint32 ui32Region,                                         \
                   uint32 ui32Addr,                                           \
                   uint32 ui32Flags))ROM_MPUTABLE[5])
#define ROM_MPURegionGet                                                      \
        ((void (*)(uint32 ui32Region,                                         \
                   uint32 *pui32Addr,                                         \
                   uint32 *pui32Flags))ROM_MPUTABLE[6])


/******************************************************************************
*
* Macros for calling ROM functions in the PWM API.
*
******************************************************************************/
#define ROM_PWMPulseWidthSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOut,                                         \
                   uint32 ui32Width))ROM_PWMTABLE[0])
#define ROM_PWMGenConfigure                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32Config))ROM_PWMTABLE[1])
#define ROM_PWMGenPeriodSet                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32Period))ROM_PWMTABLE[2])
#define ROM_PWMGenPeriodGet                                                   \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Gen))ROM_PWMTABLE[3])
#define ROM_PWMGenEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen))ROM_PWMTABLE[4])
#define ROM_PWMGenDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen))ROM_PWMTABLE[5])
#define ROM_PWMPulseWidthGet                                                  \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32PWMOut))ROM_PWMTABLE[6])
#define ROM_PWMDeadBandEnable                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint16 ui16Rise,                                           \
                   uint16 ui16Fall))ROM_PWMTABLE[7])
#define ROM_PWMDeadBandDisable                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen))ROM_PWMTABLE[8])
#define ROM_PWMSyncUpdate                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32GenBits))ROM_PWMTABLE[9])
#define ROM_PWMSyncTimeBase                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32GenBits))ROM_PWMTABLE[10])
#define ROM_PWMOutputState                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOutBits,                                     \
                   boolean bEnable))ROM_PWMTABLE[11])
#define ROM_PWMOutputInvert                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOutBits,                                     \
                   boolean bInvert))ROM_PWMTABLE[12])
#define ROM_PWMOutputFault                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOutBits,                                     \
                   boolean bFaultSuppress))ROM_PWMTABLE[13])
#define ROM_PWMGenIntTrigEnable                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32IntTrig))ROM_PWMTABLE[14])
#define ROM_PWMGenIntTrigDisable                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32IntTrig))ROM_PWMTABLE[15])
#define ROM_PWMGenIntStatus                                                   \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Gen,                                        \
                       boolean bMasked))ROM_PWMTABLE[16])
#define ROM_PWMGenIntClear                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32Ints))ROM_PWMTABLE[17])
#define ROM_PWMIntEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32GenFault))ROM_PWMTABLE[18])
#define ROM_PWMIntDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32GenFault))ROM_PWMTABLE[19])
#define ROM_PWMFaultIntClear                                                  \
        ((void (*)(uint32 ui32Base))ROM_PWMTABLE[20])
#define ROM_PWMIntStatus                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_PWMTABLE[21])
#define ROM_PWMOutputFaultLevel                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOutBits,                                     \
                   boolean bDriveHigh))ROM_PWMTABLE[22])
#define ROM_PWMFaultIntClearExt                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32FaultInts))ROM_PWMTABLE[23])
#define ROM_PWMGenFaultConfigure                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32MinFaultPeriod,                                 \
                   uint32 ui32FaultSenses))ROM_PWMTABLE[24])
#define ROM_PWMGenFaultTriggerSet                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32Group,                                          \
                   uint32 ui32FaultTriggers))ROM_PWMTABLE[25])
#define ROM_PWMGenFaultTriggerGet                                             \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Gen,                                        \
                       uint32 ui32Group))ROM_PWMTABLE[26])
#define ROM_PWMGenFaultStatus                                                 \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Gen,                                        \
                       uint32 ui32Group))ROM_PWMTABLE[27])
#define ROM_PWMGenFaultClear                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Gen,                                            \
                   uint32 ui32Group,                                          \
                   uint32 ui32FaultTriggers))ROM_PWMTABLE[28])

#define ROM_PWMOutputUpdateMode                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PWMOutBits,                                     \
                   uint32 ui32Mode))ROM_PWMTABLE[31])

/******************************************************************************
*
* Macros for calling ROM functions in the QEI API.
*
******************************************************************************/
#define ROM_QEIPositionGet                                                    \
        ((uint32 (*)(uint32 ui32Base))ROM_QEITABLE[0])
#define ROM_QEIEnable                                                         \
        ((void (*)(uint32 ui32Base))ROM_QEITABLE[1])
#define ROM_QEIDisable                                                        \
        ((void (*)(uint32 ui32Base))ROM_QEITABLE[2])
#define ROM_QEIConfigure                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Config,                                         \
                   uint32 ui32MaxPosition))ROM_QEITABLE[3])
#define ROM_QEIPositionSet                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Position))ROM_QEITABLE[4])
#define ROM_QEIDirectionGet                                                   \
        ((sint32 (*)(uint32 ui32Base))ROM_QEITABLE[5])
#define ROM_QEIErrorGet                                                       \
        ((boolean (*)(uint32 ui32Base))ROM_QEITABLE[6])
#define ROM_QEIVelocityEnable                                                 \
        ((void (*)(uint32 ui32Base))ROM_QEITABLE[7])
#define ROM_QEIVelocityDisable                                                \
        ((void (*)(uint32 ui32Base))ROM_QEITABLE[8])
#define ROM_QEIVelocityConfigure                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32PreDiv,                                         \
                   uint32 ui32Period))ROM_QEITABLE[9])
#define ROM_QEIVelocityGet                                                    \
        ((uint32 (*)(uint32 ui32Base))ROM_QEITABLE[10])
#define ROM_QEIIntEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_QEITABLE[11])
#define ROM_QEIIntDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_QEITABLE[12])
#define ROM_QEIIntStatus                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_QEITABLE[13])
#define ROM_QEIIntClear                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_QEITABLE[14])


/******************************************************************************
*
* Macros for calling ROM functions in the SMBus API.
*
******************************************************************************/
#define ROM_SMBusMasterIntProcess                                             \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[0])
#define ROM_SMBusARPDisable                                                   \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[1])
#define ROM_SMBusARPEnable                                                    \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[2])
#define ROM_SMBusARPUDIDPacketDecode                                          \
        ((void (*)(tSMBusUDID *pUDID,                                         \
                   uint8 *pui8Address,                                        \
                   uint8 *pui8Data))ROM_SMBUSTABLE[3])
#define ROM_SMBusARPUDIDPacketEncode                                          \
        ((void (*)(tSMBusUDID *pUDID,                                         \
                   uint8 ui8Address,                                          \
                   uint8 *pui8Data))ROM_SMBUSTABLE[4])

#define ROM_SMBusMasterARPAssignAddress                                       \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 *pui8Data))ROM_SMBUSTABLE[5])

#define ROM_SMBusMasterARPGetUDIDDir                                          \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 *pui8Data))ROM_SMBUSTABLE[6])

#define ROM_SMBusMasterARPGetUDIDGen                                          \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 *pui8Data))ROM_SMBUSTABLE[7])

#define ROM_SMBusMasterARPNotifyMaster                                        \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 *pui8Data))ROM_SMBUSTABLE[8])

#define ROM_SMBusMasterARPPrepareToARP                                        \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[9])

#define ROM_SMBusMasterARPResetDeviceDir                                      \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress))ROM_SMBUSTABLE[10])

#define ROM_SMBusMasterARPResetDeviceGen                                      \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[11])

#define ROM_SMBusMasterBlockProcessCall                                       \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8TxData,                                 \
                           uint8 ui8TxSize,                                   \
                           uint8 *pui8RxData))ROM_SMBUSTABLE[12])
#define ROM_SMBusMasterBlockRead                                              \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8Data))ROM_SMBUSTABLE[13])

#define ROM_SMBusMasterBlockWrite                                             \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8Data,                                   \
                           uint8 ui8Size))ROM_SMBUSTABLE[14])

#define ROM_SMBusMasterByteReceive                                            \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 *pui8Data))ROM_SMBUSTABLE[15])

#define ROM_SMBusMasterByteSend                                               \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Data))ROM_SMBUSTABLE[16])

#define ROM_SMBusMasterByteWordRead                                           \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8Data,                                   \
                           uint8 ui8Size))ROM_SMBUSTABLE[17])

#define ROM_SMBusMasterByteWordWrite                                          \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8Data,                                   \
                           uint8 ui8Size))ROM_SMBUSTABLE[18])

#define ROM_SMBusMasterHostNotify                                             \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8OwnSlaveAddress,                          \
                           uint8 *pui8Data))ROM_SMBUSTABLE[19])

#define ROM_SMBusMasterI2CRead                                                \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 *pui8Data,                                   \
                           uint8 ui8Size))ROM_SMBUSTABLE[20])

#define ROM_SMBusMasterI2CWrite                                               \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 *pui8Data,                                   \
                           uint8 ui8Size))ROM_SMBUSTABLE[21])

#define ROM_SMBusMasterI2CWriteRead                                           \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 *pui8TxData,                                 \
                           uint8 ui8TxSize,                                   \
                           uint8 *pui8RxData,                                 \
                           uint8 ui8RxSize))ROM_SMBUSTABLE[22])

#define ROM_SMBusMasterInit                                                   \
        ((void (*)(tSMBus *psSMBus,                                           \
                   uint32 ui32I2CBase,                                        \
                   uint32 ui32SMBusClock))ROM_SMBUSTABLE[23])

#define ROM_SMBusMasterIntEnable                                              \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[24])

#define ROM_SMBusMasterProcessCall                                            \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           uint8 ui8Command,                                  \
                           uint8 *pui8TxData,                                 \
                           uint8 *pui8RxData))ROM_SMBUSTABLE[25])

#define ROM_SMBusMasterQuickCommand                                           \
        ((tSMBusStatus (*)(tSMBus *psSMBus,                                   \
                           uint8 ui8TargetAddress,                            \
                           boolean bData))ROM_SMBUSTABLE[26])

#define ROM_SMBusPECDisable                                                   \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[27])

#define ROM_SMBusPECEnable                                                    \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[28])

#define ROM_SMBusRxPacketSizeGet                                              \
        ((uint8 (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[29])

#define ROM_SMBusSlaveACKSend                                                 \
        ((void (*)(tSMBus *psSMBus,                                           \
                   boolean bACK))ROM_SMBUSTABLE[30])

#define ROM_SMBusSlaveAddressSet                                              \
        ((void (*)(tSMBus *psSMBus,                                           \
                   uint8 ui8AddressNum,                                       \
                   uint8 ui8SlaveAddress))ROM_SMBUSTABLE[31])

#define ROM_SMBusSlaveARPFlagARGet                                            \
        ((boolean (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[32])

#define ROM_SMBusSlaveARPFlagARSet                                            \
        ((void (*)(tSMBus *psSMBus,                                           \
                   boolean bValue))ROM_SMBUSTABLE[33])

#define ROM_SMBusSlaveARPFlagAVGet                                            \
        ((boolean (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[34])

#define ROM_SMBusSlaveARPFlagAVSet                                            \
        ((void (*)(tSMBus *psSMBus,                                           \
                   boolean bValue))ROM_SMBUSTABLE[35])

#define ROM_SMBusSlaveBlockTransferDisable                                    \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[36])

#define ROM_SMBusSlaveBlockTransferEnable                                     \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[37])

#define ROM_SMBusSlaveCommandGet                                              \
        ((uint8 (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[38])

#define ROM_SMBusSlaveI2CDisable                                              \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[39])

#define ROM_SMBusSlaveI2CEnable                                               \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[40])

#define ROM_SMBusSlaveInit                                                    \
        ((void (*)(tSMBus *psSMBus,                                           \
                   uint32 ui32I2CBase))ROM_SMBUSTABLE[41])

#define ROM_SMBusSlaveIntAddressGet                                           \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[42])

#define ROM_SMBusSlaveIntEnable                                               \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[43])

#define ROM_SMBusSlaveIntProcess                                              \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[44])

#define ROM_SMBusSlaveManualACKDisable                                        \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[45])

#define ROM_SMBusSlaveManualACKEnable                                         \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[46])

#define ROM_SMBusSlaveManualACKStatusGet                                      \
        ((boolean (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[47])

#define ROM_SMBusSlaveProcessCallDisable                                      \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[48])

#define ROM_SMBusSlaveProcessCallEnable                                       \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[49])

#define ROM_SMBusSlaveRxBufferSet                                             \
        ((void (*)(tSMBus *psSMBus,                                           \
                   uint8 *pui8Data,                                           \
                   uint8 ui8Size))ROM_SMBUSTABLE[50])

#define ROM_SMBusSlaveTransferInit                                            \
        ((void (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[51])

#define ROM_SMBusSlaveTxBufferSet                                             \
        ((void (*)(tSMBus *psSMBus,                                           \
                   uint8 *pui8Data,                                           \
                   uint8 ui8Size))ROM_SMBUSTABLE[52])

#define ROM_SMBusSlaveUDIDSet                                                 \
        ((void (*)(tSMBus *psSMBus,                                           \
                   tSMBusUDID *pUDID))ROM_SMBUSTABLE[53])

#define ROM_SMBusStatusGet                                                    \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[54])
#define ROM_SMBusSlaveDataSend                                                \
        ((tSMBusStatus (*)(tSMBus *psSMBus))ROM_SMBUSTABLE[55])


/******************************************************************************
*
* Macros for calling ROM functions in the SSI API.
*
******************************************************************************/
#define ROM_SSIDataPut                                                        \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Data))ROM_SSITABLE[0])

#define ROM_SSIConfigSetExpClk                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32SSIClk,                                         \
                   uint32 ui32Protocol,                                       \
                   uint32 ui32Mode,                                           \
                   uint32 ui32BitRate,                                        \
                   uint32 ui32DataWidth))ROM_SSITABLE[1])

#define ROM_SSIEnable                                                         \
        ((void (*)(uint32 ui32Base))ROM_SSITABLE[2])

#define ROM_SSIDisable                                                        \
        ((void (*)(uint32 ui32Base))ROM_SSITABLE[3])

#define ROM_SSIIntEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_SSITABLE[4])

#define ROM_SSIIntDisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_SSITABLE[5])

#define ROM_SSIIntStatus                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_SSITABLE[6])

#define ROM_SSIIntClear                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_SSITABLE[7])

#define ROM_SSIDataPutNonBlocking                                             \
        ((sint32 (*)(uint32 ui32Base,                                          \
                      uint32 ui32Data))ROM_SSITABLE[8])

#define ROM_SSIDataGet                                                        \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 *pui32Data))ROM_SSITABLE[9])

#define ROM_SSIDataGetNonBlocking                                             \
        ((sint32 (*)(uint32 ui32Base,                                          \
                      uint32 *pui32Data))ROM_SSITABLE[10])

#define ROM_UpdateSSI                                                         \
        ((void (*)(void))ROM_SSITABLE[11])

#define ROM_SSIDMAEnable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32DMAFlags))ROM_SSITABLE[12])

#define ROM_SSIDMADisable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32DMAFlags))ROM_SSITABLE[13])

#define ROM_SSIBusy                                                           \
        ((boolean (*)(uint32 ui32Base))ROM_SSITABLE[14])

#define ROM_SSIClockSourceGet                                                 \
        ((uint32 (*)(uint32 ui32Base))ROM_SSITABLE[15])

#define ROM_SSIClockSourceSet                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Source))ROM_SSITABLE[16])

/******************************************************************************
*
* Macros for calling ROM functions in the SysCtl API.
*
******************************************************************************/
#define ROM_SysCtlSleep                                                       \
        ((void (*)(void))ROM_SYSCTLTABLE[0])

#define ROM_SysCtlSRAMSizeGet                                                 \
        ((uint32 (*)(void))ROM_SYSCTLTABLE[1])

#define ROM_SysCtlFlashSizeGet                                                \
        ((uint32 (*)(void))ROM_SYSCTLTABLE[2])

#define ROM_SysCtlPeripheralPresent                                           \
        ((boolean (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[4])

#define ROM_SysCtlPeripheralReset                                             \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[5])

#define ROM_SysCtlPeripheralEnable                                            \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[6])

#define ROM_SysCtlPeripheralDisable                                           \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[7])

#define ROM_SysCtlPeripheralSleepEnable                                       \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[8])

#define ROM_SysCtlPeripheralSleepDisable                                      \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[9])

#define ROM_SysCtlPeripheralDeepSleepEnable                                   \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[10])

#define ROM_SysCtlPeripheralDeepSleepDisable                                  \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[11])

#define ROM_SysCtlPeripheralClockGating                                       \
        ((void (*)(boolean bEnable))ROM_SYSCTLTABLE[12])

#define ROM_SysCtlIntEnable                                                   \
        ((void (*)(uint32 ui32Ints))ROM_SYSCTLTABLE[13])

#define ROM_SysCtlIntDisable                                                  \
        ((void (*)(uint32 ui32Ints))ROM_SYSCTLTABLE[14])

#define ROM_SysCtlIntClear                                                    \
        ((void (*)(uint32 ui32Ints))ROM_SYSCTLTABLE[15])

#define ROM_SysCtlIntStatus                                                   \
        ((uint32 (*)(boolean bMasked))ROM_SYSCTLTABLE[16])

#define ROM_SysCtlReset                                                       \
        ((void (*)(void))ROM_SYSCTLTABLE[19])

#define ROM_SysCtlDeepSleep                                                   \
        ((void (*)(void))ROM_SYSCTLTABLE[20])

#define ROM_SysCtlResetCauseGet                                               \
        ((uint32 (*)(void))ROM_SYSCTLTABLE[21])

#define ROM_SysCtlResetCauseClear                                             \
        ((void (*)(uint32 ui32Causes))ROM_SYSCTLTABLE[22])
#define ROM_SysCtlClockSet                                                    \
        ((void (*)(uint32 ui32Config))ROM_SYSCTLTABLE[23])
#define ROM_SysCtlClockGet                                                    \
        ((uint32 (*)(void))ROM_SYSCTLTABLE[24])
#define ROM_SysCtlPWMClockSet                                                 \
        ((void (*)(uint32 ui32Config))ROM_SYSCTLTABLE[25])
#define ROM_SysCtlPWMClockGet                                                 \
        ((uint32 (*)(void))ROM_SYSCTLTABLE[26])
#define ROM_SysCtlUSBPLLEnable                                                \
        ((void (*)(void))ROM_SYSCTLTABLE[31])
#define ROM_SysCtlUSBPLLDisable                                               \
        ((void (*)(void))ROM_SYSCTLTABLE[32])

#define ROM_SysCtlDelay                                                       \
        ((void (*)(uint32 ui32Count))ROM_SYSCTLTABLE[34])

#define ROM_SysCtlPeripheralReady                                             \
        ((boolean (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[35])

#define ROM_SysCtlPeripheralPowerOn                                           \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[36])

#define ROM_SysCtlPeripheralPowerOff                                          \
        ((void (*)(uint32 ui32Peripheral))ROM_SYSCTLTABLE[37])

#define ROM_SysCtlMOSCConfigSet                                               \
        ((void (*)(uint32 ui32Config))ROM_SYSCTLTABLE[44])

#define ROM_SysCtlPIOSCCalibrate                                              \
        ((uint32 (*)(uint32 ui32Type))ROM_SYSCTLTABLE[45])
#define ROM_SysCtlDeepSleepClockSet                                           \
        ((void (*)(uint32 ui32Config))ROM_SYSCTLTABLE[46])
#define ROM_SysCtlVoltageEventConfig                                          \
        ((void (*)(uint32 ui32Config))ROM_SYSCTLTABLE[55])

/******************************************************************************
*
* Macros for calling ROM functions in the SysExc API.
*
******************************************************************************/
#define ROM_SysExcIntStatus                                                   \
        ((uint32 (*)(boolean bMasked))ROM_SYSEXCTABLE[0])

#define ROM_SysExcIntClear                                                    \
        ((void (*)(uint32 ui32IntFlags))ROM_SYSEXCTABLE[1])

#define ROM_SysExcIntDisable                                                  \
        ((void (*)(uint32 ui32IntFlags))ROM_SYSEXCTABLE[2])

#define ROM_SysExcIntEnable                                                   \
        ((void (*)(uint32 ui32IntFlags))ROM_SYSEXCTABLE[3])

/******************************************************************************
*
* Macros for calling ROM functions in the SysTick API.
*
******************************************************************************/
#define ROM_SysTickValueGet                                                   \
        ((uint32 (*)(void))ROM_SYSTICKTABLE[0])

#define ROM_SysTickEnable                                                     \
        ((void (*)(void))ROM_SYSTICKTABLE[1])

#define ROM_SysTickDisable                                                    \
        ((void (*)(void))ROM_SYSTICKTABLE[2])

#define ROM_SysTickIntEnable                                                  \
        ((void (*)(void))ROM_SYSTICKTABLE[3])

#define ROM_SysTickIntDisable                                                 \
        ((void (*)(void))ROM_SYSTICKTABLE[4])

#define ROM_SysTickPeriodSet                                                  \
        ((void (*)(uint32 ui32Period))ROM_SYSTICKTABLE[5])

#define ROM_SysTickPeriodGet                                                  \
        ((uint32 (*)(void))ROM_SYSTICKTABLE[6])

/******************************************************************************
*
* Macros for calling ROM functions in the Timer API.
*
******************************************************************************/
#define ROM_TimerIntClear                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_TIMERTABLE[0])

#define ROM_TimerEnable                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer))ROM_TIMERTABLE[1])

#define ROM_TimerDisable                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer))ROM_TIMERTABLE[2])

#define ROM_TimerConfigure                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Config))ROM_TIMERTABLE[3])

#define ROM_TimerControlLevel                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   boolean bInvert))ROM_TIMERTABLE[4])
#define ROM_TimerControlTrigger                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   boolean bEnable))ROM_TIMERTABLE[5])

#define ROM_TimerControlEvent                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   uint32 ui32Event))ROM_TIMERTABLE[6])

#define ROM_TimerControlStall                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   boolean bStall))ROM_TIMERTABLE[7])

#define ROM_TimerRTCEnable                                                    \
        ((void (*)(uint32 ui32Base))ROM_TIMERTABLE[8])

#define ROM_TimerRTCDisable                                                   \
        ((void (*)(uint32 ui32Base))ROM_TIMERTABLE[9])

#define ROM_TimerPrescaleSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   uint32 ui32Value))ROM_TIMERTABLE[10])

#define ROM_TimerPrescaleGet                                                  \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Timer))ROM_TIMERTABLE[11])

#define ROM_TimerPrescaleMatchSet                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   uint32 ui32Value))ROM_TIMERTABLE[12])

#define ROM_TimerPrescaleMatchGet                                             \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Timer))ROM_TIMERTABLE[13])

#define ROM_TimerLoadSet                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   uint32 ui32Value))ROM_TIMERTABLE[14])

#define ROM_TimerLoadGet                                                      \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Timer))ROM_TIMERTABLE[15])

#define ROM_TimerValueGet                                                     \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Timer))ROM_TIMERTABLE[16])

#define ROM_TimerMatchSet                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   uint32 ui32Value))ROM_TIMERTABLE[17])

#define ROM_TimerMatchGet                                                     \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Timer))ROM_TIMERTABLE[18])

#define ROM_TimerIntEnable                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_TIMERTABLE[19])

#define ROM_TimerIntDisable                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_TIMERTABLE[20])

#define ROM_TimerIntStatus                                                    \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_TIMERTABLE[21])

#define ROM_TimerControlWaitOnTrigger                                         \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Timer,                                          \
                   boolean bWait))ROM_TIMERTABLE[22])
#define ROM_TimerLoadSet64                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint64_t ui64Value))ROM_TIMERTABLE[23])
#define ROM_TimerLoadGet64                                                    \
        ((uint64_t (*)(uint32 ui32Base))ROM_TIMERTABLE[24])
#define ROM_TimerValueGet64                                                   \
        ((uint64_t (*)(uint32 ui32Base))ROM_TIMERTABLE[25])
#define ROM_TimerMatchSet64                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint64_t ui64Value))ROM_TIMERTABLE[26])
#define ROM_TimerMatchGet64                                                   \
        ((uint64_t (*)(uint32 ui32Base))ROM_TIMERTABLE[27])

/******************************************************************************
*
* Macros for calling ROM functions in the UART API.
*
******************************************************************************/
#define ROM_UARTCharPut                                                       \
        ((void (*)(uint32 ui32Base,                                           \
                   unsigned char ucData))ROM_UARTTABLE[0])

#define ROM_UARTParityModeSet                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Parity))ROM_UARTTABLE[1])

#define ROM_UARTParityModeGet                                                 \
        ((uint32 (*)(uint32 ui32Base))ROM_UARTTABLE[2])

#define ROM_UARTFIFOLevelSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32TxLevel,                                        \
                   uint32 ui32RxLevel))ROM_UARTTABLE[3])

#define ROM_UARTFIFOLevelGet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 *pui32TxLevel,                                      \
                   uint32 *pui32RxLevel))ROM_UARTTABLE[4])

#define ROM_UARTConfigSetExpClk                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32UARTClk,                                        \
                   uint32 ui32Baud,                                           \
                   uint32 ui32Config))ROM_UARTTABLE[5])

#define ROM_UARTConfigGetExpClk                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32UARTClk,                                        \
                   uint32 *pui32Baud,                                         \
                   uint32 *pui32Config))ROM_UARTTABLE[6])

#define ROM_UARTEnable                                                        \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[7])

#define ROM_UARTDisable                                                       \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[8])

#define ROM_UARTEnableSIR                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   boolean bLowPower))ROM_UARTTABLE[9])

#define ROM_UARTDisableSIR                                                    \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[10])

#define ROM_UARTCharsAvail                                                    \
        ((boolean (*)(uint32 ui32Base))ROM_UARTTABLE[11])

#define ROM_UARTSpaceAvail                                                    \
        ((boolean (*)(uint32 ui32Base))ROM_UARTTABLE[12])

#define ROM_UARTCharGetNonBlocking                                            \
        ((sint32 (*)(uint32 ui32Base))ROM_UARTTABLE[13])

#define ROM_UARTCharGet                                                       \
        ((sint32 (*)(uint32 ui32Base))ROM_UARTTABLE[14])

#define ROM_UARTCharPutNonBlocking                                            \
        ((boolean (*)(uint32 ui32Base,                                           \
                   unsigned char ucData))ROM_UARTTABLE[15])

#define ROM_UARTBreakCtl                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   boolean bBreakState))ROM_UARTTABLE[16])

#define ROM_UARTIntEnable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_UARTTABLE[17])

#define ROM_UARTIntDisable                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_UARTTABLE[18])

#define ROM_UARTIntStatus                                                     \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_UARTTABLE[19])

#define ROM_UARTIntClear                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_UARTTABLE[20])

#define ROM_UpdateUART                                                        \
        ((void (*)(void))ROM_UARTTABLE[21])

#define ROM_UARTDMAEnable                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32DMAFlags))ROM_UARTTABLE[22])

#define ROM_UARTDMADisable                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32DMAFlags))ROM_UARTTABLE[23])

#define ROM_UARTFIFOEnable                                                    \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[24])

#define ROM_UARTFIFODisable                                                   \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[25])

#define ROM_UARTBusy                                                          \
        ((boolean (*)(uint32 ui32Base))ROM_UARTTABLE[26])

#define ROM_UARTTxIntModeSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Mode))ROM_UARTTABLE[27])

#define ROM_UARTTxIntModeGet                                                  \
        ((uint32 (*)(uint32 ui32Base))ROM_UARTTABLE[28])

#define ROM_UARTRxErrorGet                                                    \
        ((uint32 (*)(uint32 ui32Base))ROM_UARTTABLE[29])

#define ROM_UARTRxErrorClear                                                  \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[30])

#define ROM_UARTClockSourceSet                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Source))ROM_UARTTABLE[31])

#define ROM_UARTClockSourceGet                                                \
        ((uint32 (*)(uint32 ui32Base))ROM_UARTTABLE[32])

#define ROM_UART9BitEnable                                                    \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[33])

#define ROM_UART9BitDisable                                                   \
        ((void (*)(uint32 ui32Base))ROM_UARTTABLE[34])

#define ROM_UART9BitAddrSet                                                   \
        ((void (*)(uint32 ui32Base,                                           \
                   uint8 ui8Addr,                                             \
                   uint8 ui8Mask))ROM_UARTTABLE[35])

#define ROM_UART9BitAddrSend                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint8 ui8Addr))ROM_UARTTABLE[36])
#define ROM_UARTModemControlClear                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Control))ROM_UARTTABLE[39])

/******************************************************************************
*
* Macros for calling ROM functions in the uDMA API.
*
******************************************************************************/
#define ROM_uDMAChannelTransferSet                                            \
        ((void (*)(uint32 ui32ChannelStructIndex,                             \
                   uint32 ui32Mode,                                           \
                   void *pvSrcAddr,                                           \
                   void *pvDstAddr,                                           \
                   uint32 ui32TransferSize))ROM_UDMATABLE[0])

#define ROM_uDMAEnable                                                        \
        ((void (*)(void))ROM_UDMATABLE[1])

#define ROM_uDMADisable                                                       \
        ((void (*)(void))ROM_UDMATABLE[2])

#define ROM_uDMAErrorStatusGet                                                \
        ((uint32 (*)(void))ROM_UDMATABLE[3])

#define ROM_uDMAErrorStatusClear                                              \
        ((void (*)(void))ROM_UDMATABLE[4])

#define ROM_uDMAChannelEnable                                                 \
        ((void (*)(uint32 ui32ChannelNum))ROM_UDMATABLE[5])

#define ROM_uDMAChannelDisable                                                \
        ((void (*)(uint32 ui32ChannelNum))ROM_UDMATABLE[6])

#define ROM_uDMAChannelIsEnabled                                              \
        ((boolean (*)(uint32 ui32ChannelNum))ROM_UDMATABLE[7])

#define ROM_uDMAControlBaseSet                                                \
        ((void (*)(void *pControlTable))ROM_UDMATABLE[8])

#define ROM_uDMAControlBaseGet                                                \
        ((void * (*)(void))ROM_UDMATABLE[9])

#define ROM_uDMAChannelRequest                                                \
        ((void (*)(uint32 ui32ChannelNum))ROM_UDMATABLE[10])

#define ROM_uDMAChannelAttributeEnable                                        \
        ((void (*)(uint32 ui32ChannelNum,                                     \
                   uint32 ui32Attr))ROM_UDMATABLE[11])

#define ROM_uDMAChannelAttributeDisable                                       \
        ((void (*)(uint32 ui32ChannelNum,                                     \
                   uint32 ui32Attr))ROM_UDMATABLE[12])

#define ROM_uDMAChannelAttributeGet                                           \
        ((uint32 (*)(uint32 ui32ChannelNum))ROM_UDMATABLE[13])

#define ROM_uDMAChannelControlSet                                             \
        ((void (*)(uint32 ui32ChannelStructIndex,                             \
                   uint32 ui32Control))ROM_UDMATABLE[14])

#define ROM_uDMAChannelSizeGet                                                \
        ((uint32 (*)(uint32 ui32ChannelStructIndex))ROM_UDMATABLE[15])

#define ROM_uDMAChannelModeGet                                                \
        ((uint32 (*)(uint32 ui32ChannelStructIndex))ROM_UDMATABLE[16])

#define ROM_uDMAChannelSelectSecondary                                        \
        ((void (*)(uint32 ui32SecPeriphs))ROM_UDMATABLE[17])

#define ROM_uDMAChannelSelectDefault                                          \
        ((void (*)(uint32 ui32DefPeriphs))ROM_UDMATABLE[18])

#define ROM_uDMAIntStatus                                                     \
        ((uint32 (*)(void))ROM_UDMATABLE[19])

#define ROM_uDMAIntClear                                                      \
        ((void (*)(uint32 ui32ChanMask))ROM_UDMATABLE[20])

#define ROM_uDMAControlAlternateBaseGet                                       \
        ((void * (*)(void))ROM_UDMATABLE[21])

#define ROM_uDMAChannelScatterGatherSet                                       \
        ((void (*)(uint32 ui32ChannelNum,                                     \
                   uint32 ui32TaskCount,                                      \
                   void *pvTaskList,                                          \
                   uint32 ui32IsPeriphSG))ROM_UDMATABLE[22])

#define ROM_uDMAChannelAssign                                                 \
        ((void (*)(uint32 ui32Mapping))ROM_UDMATABLE[23])

/******************************************************************************
*
* Macros for calling ROM functions in the USB API.
*
******************************************************************************/
#define ROM_USBDevAddrGet                                                     \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[1])

#define ROM_USBDevAddrSet                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Address))ROM_USBTABLE[2])

#define ROM_USBDevConnect                                                     \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[3])

#define ROM_USBDevDisconnect                                                  \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[4])

#define ROM_USBDevEndpointConfigSet                                           \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32MaxPacketSize,                                  \
                   uint32 ui32Flags))ROM_USBTABLE[5])

#define ROM_USBDevEndpointDataAck                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   boolean bIsLastPacket))ROM_USBTABLE[6])

#define ROM_USBDevEndpointStall                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[7])

#define ROM_USBDevEndpointStallClear                                          \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[8])

#define ROM_USBDevEndpointStatusClear                                         \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[9])

#define ROM_USBEndpointDataGet                                                \
        ((sint32 (*)(uint32 ui32Base,                                          \
                      uint32 ui32Endpoint,                                    \
                      uint8 *pui8Data,                                        \
                      uint32 *pui32Size))ROM_USBTABLE[10])

#define ROM_USBEndpointDataPut                                                \
        ((sint32 (*)(uint32 ui32Base,                                          \
                      uint32 ui32Endpoint,                                    \
                      uint8 *pui8Data,                                        \
                      uint32 ui32Size))ROM_USBTABLE[11])

#define ROM_USBEndpointDataSend                                               \
        ((sint32 (*)(uint32 ui32Base,                                          \
                      uint32 ui32Endpoint,                                    \
                      uint32 ui32TransType))ROM_USBTABLE[12])

#define ROM_USBEndpointDataToggleClear                                        \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[13])

#define ROM_USBEndpointStatus                                                 \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Endpoint))ROM_USBTABLE[14])

#define ROM_USBFIFOAddrGet                                                    \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Endpoint))ROM_USBTABLE[15])

#define ROM_USBFIFOConfigGet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 *pui32FIFOAddress,                                  \
                   uint32 *pui32FIFOSize,                                     \
                   uint32 ui32Flags))ROM_USBTABLE[16])

#define ROM_USBFIFOConfigSet                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32FIFOAddress,                                    \
                   uint32 ui32FIFOSize,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[17])

#define ROM_USBFIFOFlush                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[18])

#define ROM_USBFrameNumberGet                                                 \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[19])

#define ROM_USBHostAddrGet                                                    \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Endpoint,                                   \
                       uint32 ui32Flags))ROM_USBTABLE[20])

#define ROM_USBHostAddrSet                                                    \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Addr,                                           \
                   uint32 ui32Flags))ROM_USBTABLE[21])
#define ROM_USBHostEndpointConfig                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32MaxPacketSize,                                  \
                   uint32 ui32NAKPollInterval,                                \
                   uint32 ui32TargetEndpoint,                                 \
                   uint32 ui32Flags))ROM_USBTABLE[22])

#define ROM_USBHostEndpointDataAck                                            \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint))ROM_USBTABLE[23])

#define ROM_USBHostEndpointDataToggle                                         \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   boolean bDataToggle,                                          \
                   uint32 ui32Flags))ROM_USBTABLE[24])

#define ROM_USBHostEndpointStatusClear                                        \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[25])

#define ROM_USBHostHubAddrGet                                                 \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Endpoint,                                   \
                       uint32 ui32Flags))ROM_USBTABLE[26])

#define ROM_USBHostHubAddrSet                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Addr,                                           \
                   uint32 ui32Flags))ROM_USBTABLE[27])

#define ROM_USBHostPwrDisable                                                 \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[28])

#define ROM_USBHostPwrEnable                                                  \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[29])

#define ROM_USBHostPwrConfig                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Flags))ROM_USBTABLE[30])

#define ROM_USBHostPwrFaultDisable                                            \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[31])

#define ROM_USBHostPwrFaultEnable                                             \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[32])

#define ROM_USBHostRequestIN                                                  \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint))ROM_USBTABLE[33])

#define ROM_USBHostRequestStatus                                              \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[34])

#define ROM_USBHostReset                                                      \
        ((void (*)(uint32 ui32Base,                                           \
                   boolean bStart))ROM_USBTABLE[35])

#define ROM_USBHostResume                                                     \
        ((void (*)(uint32 ui32Base,                                           \
                   boolean bStart))ROM_USBTABLE[36])

#define ROM_USBHostSpeedGet                                                   \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[37])

#define ROM_USBHostSuspend                                                    \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[38])

#define ROM_USBDevEndpointConfigGet                                           \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 *pui32MaxPacketSize,                                \
                   uint32 *pui32Flags))ROM_USBTABLE[41])

#define ROM_USBEndpointDMAEnable                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[42])

#define ROM_USBEndpointDMADisable                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Flags))ROM_USBTABLE[43])

#define ROM_USBEndpointDataAvail                                              \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       uint32 ui32Endpoint))ROM_USBTABLE[44])

#define ROM_USBModeGet                                                        \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[46])

#define ROM_USBEndpointDMAChannel                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint,                                       \
                   uint32 ui32Channel))ROM_USBTABLE[47])

#define ROM_USBIntDisableControl                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_USBTABLE[48])

#define ROM_USBIntEnableControl                                               \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_USBTABLE[49])

#define ROM_USBIntStatusControl                                               \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[50])

#define ROM_USBIntDisableEndpoint                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_USBTABLE[51])

#define ROM_USBIntEnableEndpoint                                              \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32IntFlags))ROM_USBTABLE[52])

#define ROM_USBIntStatusEndpoint                                              \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[53])

#define ROM_USBHostMode                                                       \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[54])

#define ROM_USBDevMode                                                        \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[55])

#define ROM_USBPHYPowerOff                                                    \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[56])

#define ROM_USBPHYPowerOn                                                     \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[57])

#define ROM_UpdateUSB                                                         \
        ((void (*)(uint8 *pui8DescriptorInfo))ROM_USBTABLE[58])

#define ROM_USBOTGMode                                                        \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[59])
#define ROM_USBHostRequestINClear                                             \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Endpoint))ROM_USBTABLE[60])
#define ROM_USBNumEndpointsGet                                                \
        ((uint32 (*)(uint32 ui32Base))ROM_USBTABLE[61])
#define ROM_USBDevLPMEnable                                                   \
        ((void (*)(uint32 ui32Base))ROM_USBTABLE[67])

/******************************************************************************
*
* Macros for calling ROM functions in the Watchdog API.
*
******************************************************************************/
#define ROM_WatchdogIntClear                                                  \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[0])

#define ROM_WatchdogRunning                                                   \
        ((boolean (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[1])

#define ROM_WatchdogEnable                                                    \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[2])

#define ROM_WatchdogResetEnable                                               \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[3])

#define ROM_WatchdogResetDisable                                              \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[4])

#define ROM_WatchdogLock                                                      \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[5])

#define ROM_WatchdogUnlock                                                    \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[6])

#define ROM_WatchdogLockState                                                 \
        ((boolean (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[7])

#define ROM_WatchdogReloadSet                                                 \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32LoadVal))ROM_WATCHDOGTABLE[8])

#define ROM_WatchdogReloadGet                                                 \
        ((uint32 (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[9])

#define ROM_WatchdogValueGet                                                  \
        ((uint32 (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[10])

#define ROM_WatchdogIntEnable                                                 \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[11])

#define ROM_WatchdogIntStatus                                                 \
        ((uint32 (*)(uint32 ui32Base,                                         \
                       boolean bMasked))ROM_WATCHDOGTABLE[12])

#define ROM_WatchdogStallEnable                                               \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[13])

#define ROM_WatchdogStallDisable                                              \
        ((void (*)(uint32 ui32Base))ROM_WATCHDOGTABLE[14])

#define ROM_WatchdogIntTypeSet                                                \
        ((void (*)(uint32 ui32Base,                                           \
                   uint32 ui32Type))ROM_WATCHDOGTABLE[15])

/******************************************************************************
*
* Macros for calling ROM functions in the Software API.
*
******************************************************************************/
#define ROM_Crc16Array                                                        \
        ((uint16 (*)(uint32 ui32WordLen,                                      \
                       const uint32 *pui32Data))ROM_SOFTWARETABLE[1])

#define ROM_Crc16Array3                                                       \
        ((void (*)(uint32 ui32WordLen,                                        \
                   const uint32 *pui32Data,                                   \
                   uint16 *pui16Crc3))ROM_SOFTWARETABLE[2])

#define ROM_Crc16                                                             \
        ((uint16 (*)(uint16 ui16Crc,                                          \
                       const uint8 *pui8Data,                                 \
                       uint32 ui32Count))ROM_SOFTWARETABLE[3])

#define ROM_Crc8CCITT                                                         \
        ((uint8 (*)(uint8 ui8Crc,                                             \
                      const uint8 *pui8Data,                                  \
                      uint32 ui32Count))ROM_SOFTWARETABLE[4])

#define ROM_pvAESTable                                                        \
        ((void *)&(ROM_SOFTWARETABLE[7]))

/******************************************************************************
*                              End of file
******************************************************************************/
#endif /* _ROM_H_ */
