/*
 * Decompiled with CFR 0.152.
 */
package UCAN;

import UCAN.Globals;
import UCAN.RXMsg;
import UCAN.Serial_connection;
import UCAN.myStatusBar;
import UCAN.serial;
import UCAN.serial_Globals;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

class SerialReader
implements Runnable {
    short Byte_Num = (short)2;
    static Timer UCANConfig_Timer;

    public SerialReader() {
        serial_Globals.state = serial_Globals.connection_state.COMPort_ok;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[21];
        int len = -1;
        try {
            len = serial_Globals.input.read(buffer);
            while (true) {
                if (len <= -1) {
                    return;
                }
                while (len < this.Byte_Num) {
                    if (!serial_Globals.stopRead) {
                        len += serial_Globals.input.read(buffer, len, this.Byte_Num - len);
                        continue;
                    }
                    len = 0;
                    break;
                }
                if (len <= 0) continue;
                switch (serial_Globals.state) {
                    case COMPort_ok: {
                        System.out.println("COMPort_ok");
                        if (buffer[0] != 89 || buffer[1] != 73) break;
                        serial_Globals.AD.cancel();
                        serial_Globals.AD.purge();
                        serial_Globals.UCAN_Timer.cancel();
                        serial_Globals.UCAN_Timer.purge();
                        UCANConfig_Timer = new Timer();
                        UCANConfig_Timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                System.out.println("ERROR");
                                if (serial_Globals.blConnect_btn) {
                                    JOptionPane.showMessageDialog(null, "Error in CAN Configuration", "Configuration error", 0);
                                }
                            }
                        }, 50L);
                        serial.Serial_Write(serial_Globals.BaudRate + 1);
                        serial_Globals.state = serial_Globals.connection_state.UCAN_ok;
                        this.Byte_Num = 1;
                        break;
                    }
                    case UCAN_ok: {
                        System.out.println("UCAN_ok");
                        if (buffer[0] != serial_Globals.BaudRate + 1) break;
                        UCANConfig_Timer.cancel();
                        UCANConfig_Timer.purge();
                        try {
                            serial_Globals.AD_resume.cancel();
                            serial_Globals.AD_resume.purge();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.out.println("Connected");
                        serial_Globals.Istesting = false;
                        Globals.comPortBar.setString("Connected");
                        Globals.comPortBar.setIndeterminate(false);
                        serial_Globals.state = serial_Globals.connection_state.UCANConfig_ok;
                        this.Byte_Num = (short)21;
                        serial.btns_status(true);
                        Globals.TimeCheckBox.setEnabled(true);
                        Globals.TimeCheckBox.setSelected(false);
                        Globals.keyCheckBox.setEnabled(true);
                        Globals.keyCheckBox.setSelected(false);
                        Globals.RTRCheckBox.setEnabled(true);
                        Globals.RTRCheckBox.setSelected(false);
                        Globals.bitRate.setText(String.valueOf(Globals.bitRate_string) + serial.baudRate[serial_Globals.BaudRate] + "Kbps" + "    ");
                        Globals.statusImageUrl = "/ok.png";
                        Globals.statusImage.setIcon(new ImageIcon(myStatusBar.class.getResource(Globals.statusImageUrl)));
                        Globals.statusConnection.setText("Connected   ");
                        Globals.Time_stamp.Start();
                        Globals.audioPath = "/Connect.wav";
                        Globals.player.run(Globals.audioPath);
                        break;
                    }
                    case UCANConfig_ok: {
                        this.RXhandler(buffer);
                        break;
                    }
                }
                len = 0;
            }
        }
        catch (IOException e) {
            Serial_connection.disconnect();
            e.printStackTrace();
        }
    }

    private void RXhandler(byte[] RX_bytes) {
        long timestamp = 0L;
        String RTR = "";
        long RXID = RX_bytes[0] & 0xFE | RX_bytes[1] << 8 | RX_bytes[2] << 16 | RX_bytes[3] << 24;
        RXID >>= 1;
        int RXL = RX_bytes[4] & 0xF;
        byte[] data = new byte[RXL];
        if ((RX_bytes[4] & 0x80) != 0) {
            RTR = "RTR";
        } else {
            RTR = "Data";
            int c = 0;
            while (c < RXL) {
                data[c] = (byte)(RX_bytes[5 + c] & 0xFF);
                c = (short)(c + 1);
            }
        }
        byte[] timestamp_array = new byte[8];
        int c = 0;
        while (c < 8) {
            timestamp_array[c] = RX_bytes[20 - c];
            c = (short)(c + 1);
        }
        timestamp = ByteBuffer.wrap(timestamp_array).getLong();
        int index = -1;
        int c2 = 0;
        while (c2 < Globals.RX.size()) {
            if (Globals.RX.get((int)c2).canID == RXID) {
                index = c2;
                break;
            }
            c2 = (short)(c2 + 1);
        }
        if (index == -1) {
            Globals.RX.add(new RXMsg(RXID, data, RTR, RXL, timestamp));
        } else {
            Globals.RX.get(index).RXMsg_Update(data, RTR, RXL, timestamp);
        }
        Globals.thrRX_tbl.resume();
    }
}

