/*
 * Decompiled with CFR 0.152.
 */
package UCAN;

import UCAN.Globals;
import UCAN.RXMsg;
import UCAN.TXMsg;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class myTable
extends JTable {
    public myTable(Object[][] rows, Object[] columns, DefaultTableModel model, short[] width) {
        model.setColumnIdentifiers(columns);
        this.setModel(model);
        this.setAutoResizeMode(4);
        this.setColumnWidth(width);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setAutoscrolls(true);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.getValueAt(row, column) instanceof Boolean) {
            return super.getDefaultRenderer(Boolean.class);
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (this.getValueAt(row, column) instanceof Boolean) {
            return super.getDefaultEditor(Boolean.class);
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public boolean isCellEditable(int data, int columns) {
        return columns == 7;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer r, int data, int columns) {
        Component c = super.prepareRenderer(r, data, columns);
        if (data % 2 == 0) {
            c.setBackground(Color.WHITE);
        } else {
            c.setBackground(Color.LIGHT_GRAY);
        }
        return c;
    }

    public void setColumnWidth(short[] width) {
        int columnCount = this.getColumnCount();
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        int i = 0;
        while (i < columnCount) {
            this.getColumnModel().getColumn(i).setPreferredWidth(width[i]);
            this.getColumnModel().getColumn(i).setCellRenderer(centerRenderer);
            ++i;
        }
    }

    public String dataToString(byte[] data) {
        String temp = data.toString();
        return temp;
    }

    private String data_prep(byte[] b, int Len) {
        String data = "";
        int c = 0;
        while (c < Len) {
            switch (Globals.data_Format) {
                case 0: {
                    data = String.valueOf(data) + String.format("%02X", b[c] & 0xFF);
                    break;
                }
                case 1: {
                    data = String.valueOf(data) + String.format("%d", b[c] & 0xFF);
                    break;
                }
                case 2: {
                    data = String.valueOf(data) + "'" + (char)(b[c] & 0xFF) + "'";
                    break;
                }
            }
            if (c < Len - 1) {
                data = Globals.data_Format == 2 ? String.valueOf(data) + "  -  " : String.valueOf(data) + "-";
            }
            c = (short)(c + 1);
        }
        return data;
    }

    private String[] ID_prep(long ID) {
        String[] CAN_ID = new String[3];
        CAN_ID[1] = "0x" + String.format("%02X", ID);
        CAN_ID[2] = String.format("%d", ID);
        switch (Globals.ID_Format) {
            case 0: {
                CAN_ID[0] = CAN_ID[1];
                break;
            }
            case 1: {
                CAN_ID[0] = CAN_ID[2];
                break;
            }
        }
        return CAN_ID;
    }

    public void addRowReceive(RXMsg m) {
        int rowCount = this.getRowCount();
        boolean found = false;
        String data = this.data_prep(m.data, m.dataLength);
        String[] CANID = this.ID_prep(m.canID);
        int i = 0;
        while (i < rowCount) {
            if (this.getValueAt(i, 0).equals(CANID[1]) || this.getValueAt(i, 0).equals(CANID[2])) {
                Globals.model_receive.setValueAt(CANID[0], i, 0);
                Globals.model_receive.setValueAt(m.dataLength, i, 2);
                Globals.model_receive.setValueAt(m.RTR, i, 1);
                Globals.model_receive.setValueAt(data, i, 3);
                Globals.model_receive.setValueAt(m.count, i, 5);
                Globals.model_receive.setValueAt(Float.valueOf((m.Now_time - m.Last_time) / 1000.0f), i, 4);
                found = true;
            }
            ++i;
        }
        if (!found) {
            Object[] canMessageArray = new Object[]{CANID[0], m.RTR, m.dataLength, data, 0, m.count};
            Globals.model_receive.addRow(canMessageArray);
        }
    }

    public void addRowTransmit(TXMsg m) {
        int rowCount = this.getRowCount();
        boolean found = false;
        String data = this.data_prep(m.data, m.Dlength);
        String[] CANID = this.ID_prep(m.ID);
        Object[] canMessageArray = new Object[]{CANID[0], m.RTR == 1 ? "RTR" : "Data", m.Dlength, data, m.timer_Per_ms / 1000, 0, m.trigger, m.isRuning};
        int i = 0;
        while (i < rowCount) {
            if (this.getValueAt(i, 0).equals(CANID[1]) || this.getValueAt(i, 0).equals(CANID[2])) {
                Globals.model_transmit.setValueAt(CANID[0], i, 0);
                Globals.model_transmit.setValueAt(data, i, 3);
                Globals.model_transmit.setValueAt(m.count, i, 5);
                Globals.model_transmit.setValueAt(m.isRuning, i, 7);
                Globals.model_transmit.setValueAt(Float.valueOf((m.Now_time - m.Last_time) / 1000.0f), i, 4);
                found = true;
            }
            ++i;
        }
        if (!found) {
            Globals.model_transmit.addRow(canMessageArray);
            Globals.model_transmit.setValueAt(m.count, rowCount, 5);
        }
    }
}

